// c't Programmierkurs
// Autor: Matthias Kalle Dalheimer, 1999
// Euro7.java
// Liest eine Datei namens in.dat mit Whrungsbetrgen, die als DM
// interpretiert werden, konvertiert diese und schreibt die
// Ergebnisse korrekt gerundet in eine Datei namens out.dat.

import java.io.*;
import java.math.BigDecimal;

class Euro7
{
    final static double EURONACHDM = 1.95583;
    public static void main( String[] args ) {
	try {
	    // Variablen deklarieren
	    String eingabezeile;
	    double dm_betrag, euro_betrag;
	    BufferedReader in = null;
	    BufferedWriter out = null;
	    
	    // Reader erzeugen, ffnet gleichzeitig Datei
	    in = new BufferedReader( 
		   new InputStreamReader( 
		     new FileInputStream( "in.dat" ) ) );
	    
	    // Writer erzeugen, ffnet gleichzeitig Datei
	    out = new BufferedWriter( 
		    new OutputStreamWriter( 
		      new FileOutputStream( "out.dat" ) ) ); 
	    
	    // zeilenweise einlesen, konvertieren und herausschreiben
	    eingabezeile = in.readLine();
	    while( eingabezeile != null ) {
		dm_betrag = 
		    Double.valueOf( eingabezeile ).doubleValue(); 
		euro_betrag = dm_betrag / EURONACHDM;
		BigDecimal euro = new BigDecimal( euro_betrag );
		BigDecimal euro_gerundet = 
		    euro.setScale( 2, BigDecimal.ROUND_HALF_UP );
		out.write( euro_gerundet.toString() );
		out.newLine();
		eingabezeile = in.readLine();
	    }
	    
	    // Dateien schlieen
	    in.close();
	    out.close();
	} catch( Exception e ) {
	    System.out.println( "Etwas ist schief gegangen" );
	}
    }
}
