unit DXCustomForceU; // 03-MAY-99 as (Arne Schpers)
{ Spielwiese fr selbstdefinierte Effekte (guid_CustomForce).
  Diese Version ist ausschlielich fr die Treiber von
  Immersion getestet - mit Microsofts SideWinder-Gerten
  funktioniert sie ohne Modifikationen definitiv nicht.

  Wer dieses Programm mit anderen Joysticks und Lenkrdern
  zum Laufen kriegt, beglckt die Redaktion (hos@ct.heise.de)
  doch bitte mit einer E-Mail, die eventuelle Modifikationen
  des Quelltexts beschreibt. }
interface
uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, MMSystem, DInput, DXInputAS, Menus;

type
  TForm1 = class(TForm)
    bPlayEffect: TButton;
    MainMenu1: TMainMenu;
    File1: TMenuItem;
    mfileExit: TMenuItem;
    mControl: TMenuItem;
    lSelectedDevice: TLabel;
    lAxes: TLabel;
    Axes1: TMenuItem;
    mAxes1: TMenuItem;
    mAxes2: TMenuItem;
    lDownloadTime: TLabel;
    procedure FormCreate(Sender: TObject);
    procedure bPlayEffectClick(Sender: TObject);
    procedure mAxesClick(Sender: TObject);
    procedure mfileExitClick(Sender: TObject);
  private
    DIJoystick: TDIJoy;
    mControlJoy1, mControlJoy2: TMenuItem;
    procedure JoystickEnumDone(Sender: TObject);
    procedure mControlItemsClick(Sender: TObject);
    function CreateEffects: Boolean;
    procedure ReleaseEffects;
  end;

var   Form1: TForm1;

implementation
{$R *.DFM}

procedure TForm1.FormCreate(Sender: TObject);
begin
  // Abzhlung aktiver Eingaberte
  TDIJoyEnumerator.Create(JoystickEnumDone);
end;

// einziger & einmaliger Rckruf von TDIJoyEnumerator
procedure TForm1.JoystickEnumDone(Sender: TObject);

  procedure InitJoystick(DIJoy: TDIJoy; var NewMenu: TMenuItem);
  begin
    if DIJoy = nil then Exit;
    // Wahlpunkt fr den Joystick
    NewMenu := TMenuItem.Create(Self);
    with NewMenu do
    begin
      OnClick := mControlItemsClick; Tag := Integer(DIJoy);
      Caption := DIJoy.ProductName; RadioItem := True;
    end;
    // Standardfeder aus
    DIJoy.SetDWordProperty(DIPROP_AUTOCENTER,0,-1);
    mControl.Add(NewMenu);
  end;

begin
  InitJoystick(DIJoy1, mControlJoy1);
  // fr ungewhnliche Systeme (wie meins im Moment)
  InitJoystick(DIJoy2, mControlJoy2);
  if DIJoy1 <> nil then
  begin
    mAxesClick(mAxes2);  // zwei Achsen
    mControlItemsClick(mControlJoy1);
  end else
  begin
    ShowMessage('Sorry, can''t find any game controllers.');
    Close;
  end;
end;

procedure TForm1.mControlItemsClick(Sender: TObject);
const FXMsgs: Array[False..True] of String = ('has','no');
begin
  if DIJoystick <> nil then ReleaseEffects; DIJoystick := nil;
  with Sender as TMenuItem do
  begin
    Checked := True;
    DIJoystick := TDIJoy(Tag);
  end;
  lSelectedDevice.Caption := Format('Selected: %s (%s Force FX)',
    [DIJoystick.ProductName,FXMsgs[not DIJoystick.ForceFeedback]]);

  bPlayEffect.Enabled := DIJoystick.ForceFeedback and CreateEffects;
end;

// Der Faulheit halber als globale Variablen
var diEffect: TDIEffect;
    diCustomForce: TDICustomForce;
    diAxes, diDirection: Array[0..1] of Integer;
    DataBuf: Array[0..999] of Integer;
    CustomFX: IDirectInputEffect;
    AxisCount: Integer;

procedure TForm1.mAxesClick(Sender: TObject);
begin
  with Sender as TMenuItem do
  begin
    Checked := True;
    AxisCount := Tag;
    lAxes.Caption := 'Axes: '+IntToStr(Tag);
  end;
  // beim Start des Programms: keine Aktion
  if mControlJoy1.Checked
    then mControlItemsClick(mControlJoy1)
    else if (mControlJoy2 <> nil) and mControlJoy2.Checked
      then mControlItemsClick(mControlJoy2);
end;

function TForm1.CreateEffects: Boolean;
var Res: HResult;
begin
  DIJoystick.Poll;   // setzt CooperativeLevel

  // Achsen- und Richtungs-Arrays
  diAxes[0] := DIJOFS_X;
  if AxisCount = 1 then diAxes[1] := 0
    else diAxes[1] := DIJOFS_Y;
  diDirection[0] := 9000;  // horizontal
  diDirection[1] := 0;  // abschlieendes 0

  // Effektspezifisches
  with diCustomForce do
  begin
    cChannels := AxisCount; cSamples := 1000;
    rglForceData := @DataBuf;
    dwSamplePeriod := 100000;  // 0.1 Sekunden
  end;

  with diEffect do
  begin
    dwSize := sizeof(diEffect);
    dwFlags := DIEFF_POLAR or DIEFF_OBJECTOFFSETS;
    dwDuration := Trunc(1.0 * DI_SECONDS);  // 1 Sekunde
    dwSamplePeriod := 0;     // Standardvorgaben benutzen
    dwGain := DI_FFNOMINALMAX;
    dwTriggerButton := DIEB_NOTRIGGER;
    cAxes := AxisCount;
    rgdwAxes := @diAxes;
    rglDirection := @diDirection;
    cbTypeSpecificParams := SizeOf(diCustomForce);
    lpvTypeSpecificParams := @diCustomForce;
  end;
  Res := DIJoystick.DIObject.CreateEffect(
    guid_CustomForce, @diEffect, CustomFX,nil);
  Result := SUCCEEDED(Res);
  if not Result then ShowMessage('Create Effect: '+ErrorString(Res));
end;

procedure TForm1.ReleaseEffects;
begin
  // doppelt gemoppelt hlt besser
  if CustomFX <> nil then CustomFX.Unload; CustomFX := nil;
  if DIJoystick <> nil then DIJoystick.Unacquire;
end;

procedure TForm1.bPlayEffectClick(Sender: TObject);
var x: Integer; DownTime: Cardinal;
begin
  DIJoystick.Acquire;
  if CustomFX <> nil then CustomFX.Unload;
  // eigentlich ein Rechteck mit 5 Hz auf der X-Achse
  diCustomForce.cSamples := 1000;
  for x := 0 to 999 do
    if Odd(x div 100) then DataBuf[x] := 10000
     else DataBuf[x] := -10000;
  DownTime := timeGetTime;
  CheckDiRes(CustomFX.SetParameters(diEffect,
     DIEP_TYPESPECIFICPARAMS or DIEP_NODOWNLOAD),'SetParameters');
  CustomFX.Download;
  DownTime := timeGetTime-DownTime;
  CustomFX.Start(1,0);
  lDownloadTime.Caption := Format(
    'Download time for 1000 samples: %d msec',[DownTime]);
end;

procedure TForm1.mfileExitClick(Sender: TObject);
begin
  Close;
end;

end.
