Attribute VB_Name = "ct_Makros"
Option Explicit

Sub Schriftprobe()
    'Ruft das Userform-Dialogfeld frmSchriftprobe auf
    ' 1999 c't/Ralf Nebelo
    
    frmSchriftprobe.Show
End Sub

Sub DuplexPrint()
    'Beidseitiges Drucken von Dokumenten auf Druckern mit Face-Up-Ablage
    ' 1999 c't/Ralf Nebelo
    Dim intPageCount As Integer
    Dim strDlgTitle As String
    Dim strDlgMsg As String
    Dim intDlgButton As Integer
    Dim intCurPage As Integer
    
    If Documents.Count = 0 Then Exit Sub
        
    intPageCount = Selection.Information(wdNumberOfPagesInDocument)
    If intPageCount = 1 Then
        ActiveDocument.PrintOut Background:=False, Range:=wdPrintRangeOfPages, Pages:=Str$(1)
        Exit Sub
    End If
    
    strDlgTitle = "Druck der geraden Seitenzahlen"
    strDlgMsg = "Legen Sie" & Str$(Int(intPageCount / 2)) & " Bltter in den Papierschacht ein," & vbCr & "und whlen Sie OK."
    intDlgButton = MsgBox(Prompt:=strDlgMsg, Buttons:=vbOKCancel, Title:=strDlgTitle)
    If intDlgButton = vbCancel Then
        Exit Sub
    Else
        For intCurPage = 2 To intPageCount Step 2
            ActiveDocument.PrintOut Background:=False, Range:=wdPrintRangeOfPages, Pages:=Str$(intCurPage)
        Next
    End If
    
    If intPageCount Mod 2 > 0 Then
        strDlgTitle = "Druck der letzten Seite"
        strDlgMsg = "Nehmen Sie den Druckstapel aus dem Drucker, " & vbCr & "legen Sie 1 neues Blatt in den Papierschacht ein, " & vbCr & "und whlen Sie OK."
        intDlgButton = MsgBox(Prompt:=strDlgMsg, Buttons:=vbOKCancel, Title:=strDlgTitle)
        If intDlgButton = vbCancel Then
            Exit Sub
        Else
            ActiveDocument.PrintOut Background:=False, Range:=wdPrintRangeOfPages, Pages:=Str$(intPageCount)
        End If
    End If
        
    strDlgTitle = "Druck der ungeraden Seitenzahlen"
    strDlgMsg = "Legen Sie den Druckstapel (gerade Seitenzahlen) mit der " & vbCr & "bedruckten Seite nach OBEN in den Papierschacht ein, " & vbCr & "und whlen Sie OK."
    intDlgButton = MsgBox(Prompt:=strDlgMsg, Buttons:=vbOKCancel, Title:=strDlgTitle)
    If intDlgButton = vbCancel Then
        Exit Sub
    Else
        For intCurPage = Int(intPageCount / 2) * 2 - 1 To 1 Step -2
            ActiveDocument.PrintOut Range:=wdPrintRangeOfPages, Pages:=Str$(intCurPage)
        Next
    End If
End Sub

Sub MonatsKalender()
    'Ruft das Userform-Dialogfeld frmMonatskalender auf
    ' 1999 c't/Ralf Nebelo
    
    frmMonatskalender.Show
End Sub

Sub ZeichensatzTabelle()
    'Erstellt eine Zeichensatztabelle mit ANSI-Codes in einem neuen Dokument
    ' 1999 c't/Ralf Nebelo
    Dim strFontName As String
    Dim intFontSize As Integer
    Dim intI As Integer
    
    Documents.Add
    With Dialogs(wdDialogFormatFont)
        .Tab = 0
        If .Display = -1 Then
            strFontName = .Font
            intFontSize = .Points
            
            ActiveDocument.Tables.Add Range:=Selection.Range, NumRows:=15, NumColumns:=16
            With Selection
                .MoveRight Unit:=wdCharacter, Count:=16, Extend:=wdExtend
                .Cells.Merge
                .ParagraphFormat.Alignment = wdAlignParagraphCenter
                .Font.Name = "Arial"
                .Font.Size = 16
                .TypeText Text:=strFontName & " (" & LTrim$(Str$(intFontSize)) & " Punkt)" & Chr$(13)
                .Font.Size = 10
                .TypeText ActivePrinter
                .MoveRight Unit:=wdCell
            End With
            
            For intI = 32 To 255
                With Selection
                    .ParagraphFormat.Alignment = wdAlignParagraphCenter
                    .Font.Name = strFontName
                    .Font.Size = intFontSize
                    .TypeText Text:=Chr$(intI) & Chr$(13)
                    .Font.Name = "Arial"
                    .Font.Size = 8
                    .TypeText Format$(intI, "000")
                    If intI < 255 Then
                        .MoveRight Unit:=wdCell
                    End If
                End With
            Next intI
            
            Selection.EndKey Unit:=wdStory
        End If
    End With
End Sub

Sub DateiSpeichern()
    'Speichert eine zweite Kopie des Dokuments in einem tglich neu angelegten Verzeichnis.
    'Vorhandene Sicherheitskopien mit gleichem Namen bleiben erhalten.
    'Ersetzt den Word-internen DateiSpeichern-Befehl.
    ' 1999 c't/Ralf Nebelo
    Dim strCopyDrv As String
    Dim strCopyDir As String
    Dim strCopyName As String
    Dim strCopyCount As Integer
    
    On Error Resume Next
    
    If Dir(ActiveDocument.FullName) > "" Then
        ActiveDocument.SaveAs FileName:=ActiveDocument.FullName
        
        strCopyDrv = "f:"
        strCopyDir = strCopyDrv & "\" & Format(Now(), "yyyy") & "-" & Format(Now(), "mm") & "-" & Format(Now(), "dd")
        If Dir(strCopyDir & "\nul") = "" Then
            If Err = 71 Then
                MsgBox Prompt:="Laufwerk ist nicht bereit.", Title:="SecondCopy"
                Exit Sub
            Else
                MkDir Path:=strCopyDir
            End If
        End If
            
        strCopyName = ActiveDocument.Name
        Do While Dir(strCopyDir & "\" & strCopyName) > ""
            strCopyCount = strCopyCount + 1
            strCopyName = Format(strCopyCount, "000") & "-" & ActiveDocument.Name
        Loop
        WordBasic.CopyFile ActiveDocument.FullName, strCopyDir & "\" & strCopyName
    Else
        Dialogs(wdDialogFileSaveAs).Show
    End If
End Sub

Sub GrafikTotal()
    'Fgt alle Grafikdateien eines Ordners in das Dokument ein
    ' 1999 c't/Ralf Nebelo
    Dim strPictDir As String
    Dim strPictName As Variant
    
    On Error Resume Next
    
    strPictDir = InputBox(Prompt:="Name des Bildordners:", Title:="GrafikTotal")
    If Dir(strPictDir & "\nul") > "" Then
        With Application.FileSearch
            .LookIn = strPictDir
            .FileName = "*.gif;*.tif;*.jpg;*.bmp;*.pcx"
            .SearchSubFolders = False
            .Execute
            For Each strPictName In .FoundFiles
                With Selection
                    .InlineShapes.AddPicture FileName:=strPictName, LinkToFile:=True, SaveWithDocument:=False
                    .TypeText vbCr & strPictName & vbCr
                End With
            Next
        End With
    Else
        MsgBox Prompt:="Bildordner nicht gefunden.", Title:="GrafikTotal"
    End If
End Sub
