' STARTBILD.VBS (c) Tobias Weltner & c't
' aktiviert in zuflliger Reihenfolge neue Startbilder

' Verbindung zu Dateisystembefehlen herstellen
set fs = CreateObject("Scripting.FileSystemObject")

bildarchiv = "C:\bilder"	' hier lagern die Startbilder

if not fs.FolderExists(bildarchiv) then
	' Ordner mit Startbildern existiert nicht!
	problem = bildarchiv + " existiert nicht. Legen Sie den Ordner an,"
	problem = problem + "und speichern Sie darin Windows-Startbilder!"
	MsgBox problem, vbExclamation
	WScript.Quit
end if

set startbilder = fs.GetFolder(bildarchiv).files
' Anzahl der vorhandenen Startbilder bestimmen:
for each bild in startbilder
	anzahl = anzahl + 1
next

if anzahl=0 then
	' gar keine Startbilder zu finden!
	problem = bildarchiv + " ist leer. Speichern Sie darin zuerst Startbilder!"
	MsgBox problem, vbExclamation
	WScript.Quit
end if

' neues Startbild per Zufall aussuchen
zufallszahl = Zufall(1, anzahl)

' dieses Bild heraussuchen
for each bild in startbilder
	zufallszahl = zufallszahl - 1
	if zufallszahl = 0 then
		' gefunden! Altes Startbild lschen, falls vorhanden
		if fs.FileExists("C:\LOGO.SYS") then
			fs.DeleteFile "C:\LOGO.SYS", vbTrue
		end if

		' neues Startbild aktivieren
		bild.Copy "C:\LOGO.SYS", vbTrue
		' Die nchste Zeile lschen, wenn Meldung strt!
		MsgBox bild.name & " wurde aktiviert!"
		exit for
	end if
next

function Zufall(min, max)
	' liefert eine Zufallszahl zwischen min und max
	randomize
	Zufall = Int(max * rnd) + min
end function