' SAVE.VBS (c) Tobias Weltner & c't
' Sichert Dateiverknpfungen

set WSHShell = CreateObject("WScript.Shell")
set fs = CreateObject("Scripting.FileSystemObject")
set args = WScript.Arguments

dir = "C:\backups"	'hier werden die Backups gelagert
if not fs.FolderExists(dir) then fs.CreateFolder(dir)

if args.count=0 then
	' Keine speziellen Argumente: also alle Dateiverknpfungen sichern
	MsgBox "Lege Backups der Verknpfungen an. Das kann einige Minuten dauern!", vbInformation
	extensionen = ReadTypes
	for each dateityp in extensionen
		BackItup dateityp, 0
	next
else
	' nur die angegebene Dateiverknpfung sichern
	BackItup(args(0)), 1
end if


sub BackItup(ext, modus)
	'sichert die angegebene Dateiverknpfung als REG-Datei
	if not CheckKey("HKCR\" + ext + "\") then
		MsgBox "Der Schlssel " & ext & " ist unbekannt!", vbExclamation
		exit sub
	end if

	on error resume next
	'Dateiname fr die Sicherheitskopie generieren
	timeStamp = date() & " " & replace(Time(),":","-") & " Uhr"
	name = Replace(ext,".","") + " vom " + timeStamp
	if modus=1 then name = InputBox("Geben Sie der Sicherheitskopie einen Namen!", "Name", name)
	regname = dir + "\" + name + ".reg"

	'Informationen aus der Registry exportieren
	befehl = "REGEDIT.EXE /E " + chr(34) + regname + chr(34) + " HKEY_CLASSES_ROOT\" + ext 
	WSHShell.Run befehl,0,vbTrue

	'Programmschlssel erfragen...
	prog = WSHShell.RegRead("HKCR\" + ext + "\")
	'... und sichern, falls er existiert:
	if (not prog="") and checkKey("HKCR\" + prog + "\") then
		temp = "C:\tmp.txt"
		befehl = "REGEDIT.EXE /E " + temp + " " + chr(34) + "HKEY_CLASSES_ROOT\" + prog + chr(34) 	
		WSHShell.Run befehl,0,vbTrue

		'aus den beiden separaten REG-Dateien eine kombinierte REG-Datei erstellen
		set dateireg = fs.OpenTextFile(regname, 8)
		set progreg = fs.OpenTextFile(temp)
		progreg.SkipLine
		progreg.SkipLine	
		do until progreg.atEndOfStream
			dateireg.WriteLine progreg.ReadLine
		loop
		dateireg.close
		progreg.close
		fs.DeleteFile temp
	end if
end sub

function CheckKey(key)
	'prft, ob ein Schlssel in der Registry existiert
	on error resume next
	vorhanden = WSHShell.RegRead(key)
	if err<>0 then
		err.clear
		CheckKey=vbFalse
	else
		CheckKey= vbTrue
	end if
end function

function ReadTypes
	'liest alle Dateitypen aus der Registry aus
	regexport = "C:\HKCR.HID"
	WSHShell.Run "REGEDIT.EXE /E " + regexport + " HKEY_CLASSES_ROOT",0,vbTrue
'____________________________________________________________________________________________________
	set eingabe = fs.OpenTextFile(regexport)
'____________________________________________________________________________________________________
	do until eingabe.atEndOfStream
		gelesen = eingabe.ReadLine
		if len(gelesen)>20 then
			if left(gelesen,20) = "[HKEY_CLASSES_ROOT\." then
				gelesen = mid(gelesen, 20)
				if Instr(gelesen, "\")=0 then
					gelesen = left(gelesen, len(gelesen)-1)
					ext = ext + gelesen + ";"
				end if
			end if
		end if
	loop
	eingabe.close
	fs.DeleteFile regexport, vbTrue
	ext = left(ext, len(ext)-1)
	ReadTypes = Split(ext, ";")
end function
