' UMBENENN.VBS (c) Tobias Weltner & c't
' ersetzt die Dateinamen eines bestimmten Dateityps innerhalb eines Ordners durch
' fortlaufende Seriennummern

' Variablen zwingend deklarieren, um Tippfehler zu vermeiden
option explicit

dim dateiliste(10000)	'Liste der gefundenen zutreffenden Dateinamen
dim fs		' Referenz zum FileSystemObject
dim frage		' Fragen an den Benutzer
dim ordner		' Dateiordner, der die Dateien enthlt
dim prefix		' Zeichenfolge, die vor der Seriennummer eingefgt werden soll
dim ext		' Extension (also Dateityp), der gesucht werden soll
dim counter	' Anzahl gefundener Dateien des gewnschten Dateityps
dim ordnerhandle	' Handle auf den Ordner, der die Dateien enthlt
dim ordnername	' genauer Pfadname des Ordners
dim datei		' Handle der Dateien im Ordner
dim dateiname	' Dateiname der untersuchten Datei, ohne Pfad und Extension
dim extension	' Extension der untersuchten Datei (Dateityp)
dim antwort	' Antwort des Benutzers auf Abfragen
dim zaehler	' laufende Seriennummer der automatisch generierten Dateinamen
dim schleife	' Schleifenvariable
dim digits		' Anzahl der Stellen, auf die die Seriennummer erweitert wird
dim modus		'1=Dateiname in Kleinbuchstaben, 2=Dateiname in Grobuchstaben

counter=0
digits = 4
modus = 2

'Zugriff auf ActiveX-Objekte des Systems herstellen
set fs = CreateObject("Scripting.FileSystemObject")

' Angaben zur Konversion erfragen
frage = "Welcher Ordner soll bearbeitet werden?"
ordner = IB(frage, "Ordner", "C:\")

' Existiert der angegebene Ordner berhaupt?
if not fs.FolderExists(ordner) then
	MsgBox "Der Ordner " & ordner & " existiert nicht! Abbruch!", vbExclamation
	WScript.Quit
end if

frage = "Wie heit die Dateiextension des Dateityps, den Sie bercksichtigen wollen?"
ext = replace(lcase(IB(frage, "Extension", "jpg")), ".", "")

frage = "Bitte geben Sie das Prefix an, das als Dateiname verwendet werden soll!"
prefix = InputBox(frage, "Prefix", "datei")

'System-Dateitypen schtzen
if ext="exe" or ext="dll" or ext="sys" or ext="vxd" then
	MsgBox "Der Dateityp " & ext & " darf auf keinen Fall umbenannt werden!", vbCritical
	WScript.Quit
end if


' Ordner mit den Dateien ffnen
set ordnerhandle = fs.GetFolder(ordner)
ordnername = ordnerhandle.path

' Jede Datei im Ordner untersuchen
for each datei in ordnerhandle.files
	dateiname = fs.GetBaseName(datei.Name)
	extension = lcase(fs.GetExtensionName(datei.Name))
	
	' richtiger Dateityp?
	if extension = ext then
		' noch kein Prefix zugeordnet?
		if not lcase(left(dateiname, len(prefix))) = lcase(prefix) or prefix="" then
			counter = counter + 1
			dateiliste(counter) = datei.path
		end if
	end if
next

'Ergebnis prsentieren
frage = "Es wurden " & counter & " zutreffende " & ext & "-Dateien gefunden." + vbCr
if counter = 0 then
	frage = frage + "Das Programm bricht ab!"
	MsgBox frage, vbInformation
	WScript.Quit
else
	frage = frage + "Wollen Sie die Dateinamen durch Seriennummern ersetzen?"
end if

'Soll wirklich konvertiert werden?
antwort = MsgBox(frage, vbYesNo + vbQuestion)
if antwort = vbYes then
	zaehler = 0
	for schleife = 1 to counter
		dateiname = prefix & format(zaehler) & "." & ext
		do while fs.FileExists(ordnername + "\" + dateiname)
			zaehler = zaehler + 1
			dateiname = prefix & format(zaehler) & "." & ext				
		loop
		set datei = fs.GetFile(dateiliste(schleife))
		if modus=1 then
			dateiname = lcase(dateiname)
		elseif modus=2 then
			dateiname = ucase(dateiname)
		end if
		datei.name = dateiname
		zaehler = zaehler + 1
	next
	MsgBox "Erledigt!", vbInformation
else
	MsgBox "Abbruch!", vbExclamation
end if

function IB(a, b, c)
	' entspricht der InputBox-Funktion, bercksichtigt aber die Abbruch-Schaltflche

	IB = InputBox(a, b, c)
	if IB="" then
		MsgBox "Abbruch!", vbInformation
		WScript.Quit
	end if
end function

function format(zahl)
	' formatiert eine Zahl durch vorangestellte "0" und erweitert die Zahl auf diese
	' Weise auf die in der Variablen digit festgelegten Stellen

	format = string(digits-len(cstr(zahl)), "0") & zahl
end function