# TCL-Applet fr Solitaire im Browser

# Diese Policy erlaubt das Konntakten des Ursprungsservers
catch {policy home}

. configure -bg "#ffffcc"

# Masse der Felder
set fpad    5
set fwidth 40

set arrowstat true

# Oberflche erzeugen

canvas .feld -height [expr $fwidth*7] -width [expr $fwidth*7] -bg "#ffffcc"
label .label -text "Viel Glck!" -bg "#ffffcc"
frame .cmd -bg "#ffffcc"
button .cmd.back -text "Zurck" -command takeback
button .cmd.newg -text "Neues Spiel" -command newgame
button .cmd.help -text "Hilfe" -command help

# Spielfeld erzeugen
# die widgets werden auch gleichzeitig als 'interne Brettdarstellung'
# verwendet.

set n 0

for {set j 0} {$j<7} {incr j} {
    if {$j>1 && $j<5} {set ja 0 ; set je 7} {set ja 2 ; set je 5}
    for {set i $ja} {$i<$je} {incr i} {
	set name($n) "$i,$j"
	incr n
	set feld($i,$j) [.feld create oval \
		[expr $fpad+$i*$fwidth] [expr $fpad+$j*$fwidth] \
		[expr $i*$fwidth+($fwidth-$fpad)] \
		[expr $j*$fwidth+($fwidth-$fpad)] \
		-fill red]
	set brett($i,$j) belegt
	.feld bind $feld($i,$j) "<Any-Button-1>" [subst {action $i $j}]
    }
}

# Mittleres Feld ist zu Anfang leer

.feld itemconfigure $feld(3,3) -fill black
set brett(3,3) frei

# Alles anzeigen

pack .feld
pack .label -expand 1 -fill both -pady 8
pack .cmd -expand 1 -fill both
pack .cmd.back .cmd.newg -side left
pack .cmd.help -side right


# Globale Variablen initialisieren

# In 'status' merken wir uns, was als nchstes vom Benutzer erwartet wird
# from     Der benutzer whlt das Ausgangsfeld
# to       Der Benutzer whlt das Zielfeld (weil es mehrere gab)
# helping  Das System hat den Server konntaktet und noch keine Antwort
# helped   Das System hat alle Lsungszge angezeigt und muss die Pfeile
#          vor einem Benutzerzug wieder lschen

set status from

# Zugzhler fr die Zugrcknahmefunktion
set movenb 0

.cmd.back configure -state disabled
.cmd.newg configure -state disabled

# Prfe ob der Zug von (a,b) nach (c,d) mglich ist

proc move_legal {a b c d} {
    global brett

    # Felder mssen existieren
    if [catch {set brett($a,$b)}] {return 0}
    if [catch {set brett($c,$d)}] {return 0}

    # Felder mssen den richtigen Abstand haben
    if {!((abs($a-$c)==2 && $b==$d) || ($a==$c && abs($b-$d)==2))} {
	return 0
    }
    # Ausgangsfeld und berspringfeld mssen belegt sein
    # Zielfeld frei
    if {$brett($a,$b)=="belegt" && $brett($c,$d)=="frei" && \
	    $brett([expr $a+($c-$a)/2],[expr $b+($d-$b)/2])=="belegt"} {
	return 1
    } {
	return 0
    }
}

# Diese Prozedur wird immer Aufgerufen, wenn der Benutzer auf ein Feld
# klickt. Anhand des Status wird entschieden, was weiter zu tun ist.

proc action {i j} {
    global status fromi fromj feld brett movei movej movelist movenb
    
    if {$status=="helping"} {
	# Wir helfen gerade...
	# In dieser Version lassen wir uns dabei nicht stren.
	# Normalerweise dauert das eh nich lange
	.label configure -bg red
	.label configure -text "Serveranfrage luft noch!"
	after 500 {.label configure -bg "#ffffcc"}
	return
    }

    if {$status=="helped"} {
	# Wir haben geholfen und mssen die Pfeile entfernen
	set status from
	remove_arrows
    }

    switch $status {
	# Der Benutzer whlt das Ausgangsfeld
	from {
	    if {$brett($i,$j)=="belegt"} {
		set num [find_moves $i $j green]
		if {! $num} {
		    .label configure -text \
			    "Von diesem Feld aus gibt es keinen Zug"
		    return
		}
		set fromi $i
		set fromj $j
		set status to
		if {$num>1} {
		    # Es gibt mehrere mgliche Zge
		    .label configure -text "Whle Zielfeld"
		} {
		    action $movei $movej
		}
	    } {
		# Hm, Feld war leer
		.label configure -text "Whle ein besetztes Feld"
	    }
	}
	to {
	    # Benutzer hat schon das Ausgangsfeld gewhlt (in den Variablen
	    # fromi und fromj) und whlt jetzt das Zielfeld
	    if [move_legal $fromi $fromj $i $j] {
		# Zug ist mglich:
		# Pfeile entfernen und ausfhren
		remove_arrows

		set status from
		set a [expr $fromi+($i-$fromi)/2]
		set b [expr $fromj+($j-$fromj)/2]

		set brett($fromi,$fromj) frei
		set brett($i,$j) belegt
		set brett($a,$b) frei
		.feld itemconfigure $feld($fromi,$fromj) -fill black
		.feld itemconfigure $feld($i,$j) -fill red
		.feld itemconfigure $feld($a,$b) -fill black 
		.label configure -text ""

		set movelist($movenb) "$fromi,$fromj:$i,$j:$a,$b"
		incr movenb
		.cmd.back configure -state normal
		.cmd.newg configure -state normal

		if {$movenb==31} {
		    if {$brett(3,3)=="belegt"} {
			# Ende vom Spiel und gewonnen
			.label configure -text "Herzlichen Glckwunsch!!"
		    } {
			# Ende, aber nicht gewonnen
			.label configure -text "Pech gehabt"
		    }
		}
	    } elseif {$i==$fromi && $j==$fromj} {
		.feld itemconfigure $feld($i,$j) -fill red
		set status from
		.label configure -text ""
		remove_arrows
	    } {
		# Der Zug geht nicht
		.label configure -text "Unmglicher Zug"
	    }
	}
    }
}

# Diese Prozedur gibt die Anzahl der mglichen Zge von einem gegebenen
# Feld aus zurck. Ausserdem gibt sie noch einen mglichen Zug in die
# globalen Variablen (movei,movej), der von der Hauptschleife sofort 
# ausgefhrt wird, wenn er der einzige ist.

proc find_moves {i j opt} {
    global brett feld movei movej

    set number 0

    foreach x {{0 2} {0 -2} {2 0} {-2 0}} {
	set a [expr $i+[lindex $x 0]]
	set b [expr $j+[lindex $x 1]]

	if [move_legal $i $j $a $b] {
	    draw_arrow $i $j $a $b yellow
	    incr number
	    set movei $a
	    set movej $b
	}
    }
    return $number
}

# Alles zurcksetzen fr Neues Spiel

proc newgame {} {
    global movenb status brett feld

    remove_arrows

    set movenb 0
    set status from

    foreach k [array names brett] {
	set brett($k) belegt
	.feld itemconfigure $feld($k) -fill red
    }

    set brett(3,3) frei
    .feld itemconfigure $feld(3,3) -fill black
    .label configure -text "Neues Spiel, neues Glck!"
    .cmd.back configure -state disabled
}

# Letzten Zug zurcknehmen, dabei auf Status achten

proc takeback {} {
    global movenb movelist brett feld fromi fromj status

    remove_arrows

    if {$status=="to"} {
	set status from
    }

    incr movenb -1
    regexp {^(.*),(.*):(.*),(.*):(.*),(.*)$} $movelist($movenb) dummy \
	    fi fj ti tj a b

    set brett($fi,$fj) belegt
    set brett($ti,$tj) frei
    set brett($a,$b) belegt
    .feld itemconfigure $feld($fi,$fj) -fill red
    .feld itemconfigure $feld($ti,$tj) -fill black
    .feld itemconfigure $feld($a,$b) -fill red

    if {$movenb==0} {.cmd.back configure -state disabled}
}

# Einen Hilfe-Pfeil malen
# von der Darstellung xx-xx
proc draw_arrow_z {zug} {
    binary scan "a1" "cc" di dj
    set di [expr -1*$di]
    set dj [expr -1*$dj]

    binary scan $zug "ccxcc" vi vj ni nj

    incr vi $di
    incr ni $di

    set vj [expr 6-($vj+$dj)]
    set nj [expr 6-($nj+$dj)]

    draw_arrow $vi $vj $ni $nj green
}

# Einen Pfeil malen mit den internen Koordinaten und gegebner Farbe

proc draw_arrow {vi vj ni nj color} {
    global arrowlist fpad fwidth arrowstat

    if {$arrowstat=="false"} return

    set arrowwidth 8
    set hhwidth 1
    set vhwidth 2

    if {$vi==$ni} {set vhwidth 0} {set hhwidth 0}

    set hwidth [expr ($fwidth-$fpad)/2]

    set arrow [.feld create line \
		   [expr $fpad+$vi*$fwidth+$hwidth-$hhwidth] \
		   [expr $vj*$fwidth+$hwidth+$vhwidth] \
		   [expr $fpad+$ni*$fwidth+$hwidth-$hhwidth] \
		   [expr $nj*$fwidth+$hwidth+$vhwidth] \
		   -fill $color -width $arrowwidth -smooth 1 -arrow last]

    .feld bind $arrow "<Any-Button-1>" [subst {make_arrow_move $vi $vj $ni $nj}]
    
    lappend arrowlist $arrow
}

# Alle Pfeile lschen

proc remove_arrows {} {
    global arrowlist arrowstat

    if {$arrowstat=="false"} return

    if {! [catch {set arrowlist}]} {
	foreach arrow $arrowlist {
	    .feld delete $arrow
	}
	unset arrowlist
    }
}

# Diese Prozedur fhrt einen Zug aus, wenn der Benutzer auf einen Pfeil
# klickt. Sie wird jedem Pfeil mit der Methode 'bind' zugeordnet

proc make_arrow_move {vi vj ni nj} {
    global status arrowstat

    set arrowstat false

    if {$status=="from" || $status=="helped"} {action $vi $vj}
    
    if {$status=="to"} {action $ni $nj}

    set arrowstat true
    remove_arrows
}

# Hilfe-Funktion
# Sende aktuelle Position an den Server und erhalte Anzahl mglicher Lsungen
# fr jeden Lsungszug

proc help {} {
    global brett name status fromi fromj status movenb

    set i 1

    if {$status=="to"} {action $fromi $fromj} {remove_arrows}

    set status helping

    .label configure -text "Serveranfrage luft..."
    .cmd.back configure -state disabled
    .cmd.newg configure -state disabled
    .cmd.help configure -state disabled

    for {set n 0} {$n<33} {incr n} {
	if {$brett($name($n))=="frei"} {append q "o"} {append q "x"}
    }

    # Hier die entsprechende URL eintragen

    if [catch {set info [browser::getURL "/cgi-bin/ucgi/eichler/solitair?$q"]}] {
	.label configure -text "Keine Hilfe mit dem Internet Explorer moeglich!"
	.label configure -bg red
	after 2000 {.label configure -bg "#ffffcc"}
	if {$movenb>0} {.cmd.newg configure -state normal}
	if {$movenb>0} {.cmd.back configure -state normal}
	set status from
	return
    }

    foreach l [split $info "\n"] {
	if [regexp {Zug: (..-..) \((.*) Loesungen\)} $l dummy zug lsg] {
	    if {$lsg>0} {
		draw_arrow_z $zug 
		append hilfe "${zug}($lsg)" } {
		    draw_arrow_z $zug
		    append hilfe "${zug}" 
		}
	    if {$i%3==0} {append hilfe "\n"} {append hilfe " "}
	    incr i
	}
    }
    if {$i==1} {
	set hilfe "Keine Lsungen mehr mglich!"
	after 1000 {.label configure -bg "#ffffcc"}
	.label configure -bg red
	set status from
    } {set status helped}

    .label configure -text $hilfe
    .cmd.help configure -state normal
    if {$movenb>0} {.cmd.newg configure -state normal}
    if {$movenb>0} {.cmd.back configure -state normal}
}

