/**************************************************************************/
/**************************************************************************/
/**                                                                      **/
/**               TU Muenchen - Institut fuer Informatik                 **/
/**                                                                      **/
/** Program for the game of Solitair  V1.1                               **/
/**                                                                      **/
/**            Joern Eichler                                             **/
/**            Jochen Jaeger                                             **/
/**            Thomas Ludwig                                             **/
/**                                                                      **/
/** File:      pack_disktable.c                                          **/
/**                                                                      **/
/**************************************************************************/
/**************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <limits.h>

#define MAX_ENTRIES 1700000

#ifndef STYPE
#define STYPE unsigned long long
#endif

#define ULONG unsigned long

ULONG HASHSIZE = 8;
#define HASHENTRY HashEntry

struct HashEntry {
    STYPE hashindex;		/* The board */
    STYPE solutions;		/* Number of solutions from this pos. */
};

#ifndef BIG_ENDIAN
#define BIG_ENDIAN 4321
#endif
#ifndef LITTLE_ENDIAN
#define LITTLE_ENDIAN 1234
#endif

unsigned short byte_order = BIG_ENDIAN;		/* hope for the best... */

union {
    ULONG ll;
    unsigned char bytes[4];
} endian;

void check_byte_order(void)
{
    endian.ll = 0x01020304;
    if (endian.bytes[0] == 1)
	/* Big Endian 
	 * so nothing to change... */
	;
    else
	/* Hmm... Little Endian
	 * we have to change all values... */
	byte_order = LITTLE_ENDIAN;
}

STYPE little_to_big(STYPE x)
{
    STYPE y;

        ((char *)&y)[0] = ((char *)&x)[7];                           
        ((char *)&y)[1] = ((char *)&x)[6];                          
        ((char *)&y)[2] = ((char *)&x)[5];                           
        ((char *)&y)[3] = ((char *)&x)[4];    
        ((char *)&y)[4] = ((char *)&x)[3];                           
        ((char *)&y)[5] = ((char *)&x)[2];                          
        ((char *)&y)[6] = ((char *)&x)[1];                           
        ((char *)&y)[7] = ((char *)&x)[0];    

    return y;
}

ULONG ULONG_little_to_big(ULONG x)
{
    /* same thing for 32-bit */

    ULONG y;

    ((char *) &y)[0] = ((char *) &x)[3];
    ((char *) &y)[1] = ((char *) &x)[2];
    ((char *) &y)[2] = ((char *) &x)[1];
    ((char *) &y)[3] = ((char *) &x)[0];
    return y;
}

int compare(const void *a, const void *b)
{
    struct HashEntry *lhs, *rhs;
    lhs=(struct HashEntry *)a;
    rhs=(struct HashEntry *)b;
    if (lhs->hashindex < rhs->hashindex)
	return -1;
    else if (lhs->hashindex == rhs->hashindex)
	return 0;
    else
	return 1;
}

int main(int argc, char *argv[])
{
    struct HASHENTRY h;
    ULONG hindex;
    static struct HASHENTRY table[MAX_ENTRIES];
    int i;
    long insg = 0;
    FILE *disktable;
    FILE *wp;

    check_byte_order();
    disktable = fopen(argv[1], "r");
    if (!disktable) {
	printf("Disktable file not found!\n");
	exit(0);
    }
    fread((void *) &hindex, sizeof(hindex), 1, disktable);
    if(byte_order==LITTLE_ENDIAN)
      HASHSIZE = ULONG_little_to_big(hindex);
    else
      HASHSIZE = hindex;
    printf("Using %ld MByte memory for my table\n\n", HASHSIZE);

    while (1) {
	fread((void *) &h, sizeof(struct HashEntry), 1, disktable);
	if (feof(disktable))
	    break;
	if (h.solutions != 0) {
	    if(byte_order==LITTLE_ENDIAN)
	      {
		table[insg].solutions = little_to_big(h.solutions);
		table[insg].hashindex = little_to_big(h.hashindex);
	      }
	    else
	      {
		table[insg].solutions = h.solutions;
		table[insg].hashindex = h.hashindex;
	      }
	    insg++;
	    if (insg >= MAX_ENTRIES) {
		printf("Error, max entries %d reachd\n", MAX_ENTRIES);
		exit(0);
	    }
	}
	if (insg % 1000 == 0)
	    printf("\rEntries read: %ld  Disk Position: %ld", insg, ftell(disktable));
    }
    fclose(disktable);
    printf("\nO.K. Now we have read all the stuff (%ld items), lets sort it\n", insg);
    qsort(table, insg, sizeof(struct HashEntry), compare);
    printf("Fine, now its sorted, lets print it out\n");
    wp = fopen("disktable", "wb");
    for (i = 0; i < insg; i++)
      {
	if (byte_order==LITTLE_ENDIAN)
	  {
	    table[i].solutions = little_to_big(table[i].solutions);
	    table[i].hashindex = little_to_big(table[i].hashindex);
	  }
	fwrite((void *) &table[i], sizeof(struct HashEntry), 1, wp);
      }
    fclose(wp);
//      printf("Index: %lld Solutions: %lld\n", table[i].hashindex, table[i].solutions);
    return 1;
}
