unit DelphiChatU; // 12-FEB-99 as (Arne Schpers)
{ DirectPlay-Demo 1 - Der unvermeidliche Chatter, der sich mit
  dem DirectX-Sample DPCHAT unterhalten kann (gleicher GUID,
  gleiches Protokoll).
  Features:
  - Registrierung per Mausklick, danach Start ber Lobby mglich
  - Beim Direktstart: Suche nach Sessions im lokalen Netz ber
    TCP/IP. Erste Instanz legt eine Session an, weitere Instanzen
    verbinden sich mit dieser Session. Als Sitzungsname wird
    der Computername verwendet, als Spielername der Benutzername.
  - 220 Zeilen fr die Funktionalitt des SDK-Beispiels DPCHAT
    (das 1350 Zeilen hat), 100 Zeilen fr Datendurchsatzmessung.
}
interface
uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ActiveX, DPlay, DPLobby, DXPlayAS,
  DXPlayASUtils, MMSystem;  // MMSystem zur Zeitmessung

type
  TDChatForm = class(TForm)
    bRegisterApp: TButton;
    lStatus: TLabel;
    ChatBox: TListBox;
    eMsg: TEdit;
    DataSizeBar: TScrollBar;
    lDataSize: TLabel;
    bSendData: TButton;
    cSync: TCheckBox;
    cGuaranteed: TCheckBox;
    procedure FormCreate(Sender: TObject);
    procedure bRegisterAppClick(Sender: TObject);
    procedure FormKeyPress(Sender: TObject; var Key: Char);
    procedure DataSizeBarChange(Sender: TObject);
    procedure bSendDataClick(Sender: TObject);
  private
    SessionList: TObjectList;
    procedure SessionEnumerationDone(Sender: TObject);
   function ModifyConnectionInfo(const ConnInfo:
     PDPLConnection): Boolean;  // Callback bei Lobby-Verbindung
  protected
    procedure HandleSystemMsg(Sender: TObject);
    procedure HandleUserMsg(Sender: TObject);
  end;

var
  DChatForm: TDChatForm;

implementation
{$R *.DFM}

// -- GUID und selbstdefinierter Nachrichtentyp aus DPCHAT --
const ChatGUID: TGUID =
  (D1: $5bfdb060; D2:$6a4; D3:$11d0;
   D4: ($9c, $4f, $0, $a0, $c9, $5, $42, $5e));

const
  APPMSG_CHATSTRING = 0; // aus DPCHAT
  APPMSG_DATA = 1;
  SessionFlags =  DPSESSION_KEEPALIVE or DPSESSION_MIGRATEHOST
      or DPSESSION_DIRECTPLAYPROTOCOL;  // fr neue Sessions
type
  MSG_CHATSTRING = record
    dwType: DWord;
    szMsg: Array[0..0] of Char;
  end;
  PMSG_CHATSTRING = ^MSG_CHATSTRING;

  MSG_DATA = record
    dwType: DWord;
    dwSeqNumber: Integer;
    dwData: Array[0..0] of Byte;
  end;
  PMSG_DATA = ^MSG_DATA;

// --- Verbindungsaufnahme -------------------------------
function TDChatForm.ModifyConnectionInfo(const ConnInfo:
   PDPLConnection): Boolean;  // Callback bei Lobby-Verbindung
begin
  with ConnInfo^ do
    if dwFlags and DPLCONNECTION_CREATESESSION <> 0 then
      lpSessionDesc^.dwFlags := SessionFlags;
  Result := True;
end;

procedure TDChatForm.FormCreate(Sender: TObject);
var Res: HResult; CompoundAddress: Pointer;
  procedure HardExit(Msg: String);
  begin
    ShowMessage(Msg); DPlayer.Free; Halt;
  end;
begin
  DataSizeBarChange(Self);  // Anzeige, sonst nichts
  bSendData.Enabled := False;
  DPlayer := TDPlayer.Create(Self);
  with DPlayer do
  begin
    OnSystemMsg := HandleSystemMsg;
    OnUserMsg := HandleUserMsg;
    OnModifyConnInfo := ModifyConnectionInfo;
    Res := ConnectUsingLobby;  // immer zuerst probieren!
  end;
  if SUCCEEDED(Res) then
  with DPlayer do
  begin
    lStatus.Caption := Format('Lobby connect: %s, Player "%s"',
      [SessionDesc.lpszSessionName,PlayerName]);
    bSendData.Enabled := True;
  end else
   if Res <> DPERR_NOTLOBBIED then HardExit(ErrorString(Res))
   else  // DPlay-Objekt und Verbindungsdaten einzeln zusammenbauen
   with DPlayer do
   begin
     Res := CoCreateInstance(CLSID_DirectPlay, nil,
       CLSCTX_INPROC_SERVER, IID_IDirectPlay4A, DPlayObject);
     if FAILED(Res) then
       HardExit('Create DirectPlay Object: '+ ErrorString(Res));
     CompoundAddress := CreateTCPIPAddress('');
     Res := DPlayObject.InitializeConnection(CompoundAddress^,0);
     if FAILED(Res)
       then HardExit('Establish Connection: '+ErrorString(Res));
     // ber diese Verbindung erreichbare Sessions auflisten
     lStatus.Caption := 'Searching Sessions...';
     SessionList := TObjectList.Create;
     SessionEnumerator := TSessionEnumerator.Create(Self);
     with SessionEnumerator do
     begin
       DPObject := DPlayObject;
       ApplicationGuid := ChatGUID;
       TargetList := SessionList;
       OnEnumDone := SessionEnumerationDone;
       Start;
     end;
   end; // else ist die Verbindung via Lobby zustandegekommen
end;

procedure TDChatForm.SessionEnumerationDone(Sender: TObject);
var CPName: Array[0..49] of Char;
    CPSize: Integer; ConnFlags: Integer;
begin
  with SessionEnumerator do
  begin
    if (SessionList.Count = 0) and not TimedOut then Exit;
    Stop;  // DPlayObject aus dem Enum-Modus raus!
  end;
  with DPlayer do
  begin
    FillChar(SessionDesc,SizeOf(SessionDesc),0);
    with SessionDesc do
    begin
      dwSize := Sizeof(SessionDesc);
      // optional: lpszPassword setzen
      if SessionList.Count > 0 then
      begin
        guidInstance := PGUID(SessionList.Objects[0])^;
        ConnFlags := DPOPEN_JOIN;
        lStatus.Caption := 'Joining Session '+SessionList[0];
      end else
      begin
        guidApplication := ChatGUID;
        CPSize := SizeOf(CPName)-1;
        if not GetComputerName(CPName,CPSize)
          then CPName := 'NONAME';
        lpszSessionName := CPName;
        // fr lpszPassword: + DPSESSION_PASSWORDREQUIRED
        dwFlags := SessionFlags;
        ConnFlags := DPOPEN_CREATE;
        lStatus.Caption := 'Creating Session '+CPName;
      end;
    end;
    lStatus.Update;
    CheckRes(DPlayObject.Open(SessionDesc,ConnFlags),
      'Session create/connect');
    // Player anlegen
    CPSize := SizeOf(CPName)-1;
    if not GetUserName(CPName,CPSize) then CPName := 'Unknown Player';
  end;
  lStatus.Caption := lStatus.Caption + ', creating Player '+CPName;
  lStatus.Update;
  CheckRes(DPlayer.CreatePlayer(CPName,nil,0,0),'Create Player:');
  bSendData.Enabled := True;
end;

// ------------ Senden und Empfang ------------------
procedure TDChatForm.FormKeyPress(Sender: TObject; var Key: Char);
var MsgSize: Integer; MsgRec: PMSG_CHATSTRING; Msg: String;
begin
  if (Key = #13) and (ActiveControl = eMsg) and DPlayer.Connected then
  begin
    Key := #0; Msg := eMsg.Text;
    ChatBox.Items.Add(Format('%s>    %s',[DPlayer.PlayerName,Msg]));
    MsgSize := SizeOf(MsgRec^)+Length(eMsg.Text); //1 Byte ist eh drin
    MsgRec := AllocMem(MsgSize);
    with MsgRec^ do
    begin
      dwType := APPMSG_CHATSTRING;  // = 0
      Move(PChar(Msg)^,szMsg,Length(Msg)+1);  // + NUL
    end;
    DPlayer.Send(DPID_ALLPLAYERS,DPSEND_GUARANTEED or
                            DPSEND_ASYNC,MsgRec,MsgSize);
    FreeMem(MsgRec);
    eMsg.Text := '';
  end;
end;

procedure TDChatForm.HandleSystemMsg(Sender: TObject);  // DPlayer
begin
  with DPlayer, MsgData^ do
   case dwType of
    DPSYS_SENDCOMPLETE:
       with PDPMsg_SendComplete(MsgData)^ do
       begin
         ChatBox.Items.Add(Format('Nachricht %d gesendet, Delay =%d',
           [dwMsgID, dwSendTime]));
         if FAILED(hr) then
           ChatBox.Items.Add(' *** '+ErrorString(hr));
       end;
    DPSYS_CREATEPLAYERORGROUP:
       ChatBox.Items.Add(Format('"%s" ist neu dazugekommen',
       [PDPMSG_CREATEPLAYERORGROUP(MsgData)^.dpnName.lpszShortName]));
    DPSYS_DESTROYPLAYERORGROUP:
       ChatBox.Items.Add(Format('"%s" hat die Sitzung verlassen',
      [PDPMSG_DESTROYPLAYERORGROUP(MsgData)^.dpnName.lpszShortName]));
    DPSYS_HOST:
       ChatBox.Items.Add('Diese Maschine ist jetzt der Host');
    else
       ChatBox.Items.Add(Format('Systemnachricht: %x',[dwType]));
   end;
end;

var DataStartTime: Integer;  // Durchsatzmessung

procedure TDChatForm.HandleUserMsg(Sender: TObject);  // DPlayer
var SenderName: PDPName; SenderNameSize: Integer; S: String;
begin
  with DPlayer, DPlayObject do
  begin  // Namen des Absenders ermitteln
    GetPlayerName(MsgIDFrom,nil,SenderNameSize);
    GetMem(SenderName,SenderNameSize);
    GetPlayerName(MsgIDFrom,SenderName,SenderNameSize);
    S := Format('%s>   ',[SenderName.lpszShortName]);
    case MsgData^.dwType of
      APPMSG_CHATSTRING:
        ChatBox.Items.Add(Format('%s%s',
          [S,PMSG_CHATSTRING(MsgData)^.szMsg]));
      APPMSG_DATA:
        with PMSG_DATA(MsgData)^ do
        begin
          Chatbox.Items.Add(Format('%s (%d Bytes Data, Seq=%d)',
            [S, MsgDataSize, dwSeqNumber]));
          if dwSeqNumber = 0 then DataStartTime := timeGetTime;
          if dwSeqNumber = 9 then ChatBox.Items.Add(Format(
            '%d Bytes in %d msec = %d Bytes/sec',
            [MsgDataSize*10, timeGetTime-DataStartTime,
            (MsgDataSize*10*1000) div (timeGetTime-DataStartTime)]));
        end;
      else
        ChatBox.Items.Add(Format('%s(dwType = %d?)',
          [S, MsgData^.dwType]));
    end
  end;
  FreeMem(SenderName);
end;

// -----------------------------------------
procedure TDChatForm.bRegisterAppClick(Sender: TObject);
var AppDesc: TDPApplicationDesc;  Res: HResult;
    FName, Path: String;
begin
 FillChar(AppDesc,SizeOf(AppDesc),0);
 FName := ExtractFileName(ParamStr(0));
 Path := ExtractFilePath(ParamStr(0));
 with AppDesc do
 begin
   dwSize := SizeOf(AppDesc);
   lpszApplicationName := 'DelphiChat';
   guidApplication := ChatGUID;
   lpszFileName := PChar(FName);
   lpszCommandLine := nil;
   lpszPath := PChar(Path);
//   lpszDescription := 'Delphi Chat';  // nur fr Unicode?
 end;
 Res := DPlayer.DPlayLobbyObject.RegisterApplication(0,AppDesc);
 if FAILED(Res) then ShowMessage(ErrorString(Res));
end;

// --------- Datendurchsatzmessung ----------------
procedure TDChatForm.DataSizeBarChange(Sender: TObject);
begin
  lDataSize.Caption := IntToStr(1 shl DataSizeBar.Position);
end;

procedure TDChatForm.bSendDataClick(Sender: TObject);
var x, DSize, STime, SendFlags: Integer; PData: PMSG_DATA;
begin
  DSize := (1 shl DataSizeBar.Position);
  GetMem(PData,DSize); PData^.dwType := APPMSG_DATA;
  if cSync.Checked then SendFlags := 0
   else SendFlags := DPSEND_ASYNC;
  if cGuaranteed.Checked
    then SendFlags := SendFlags or DPSEND_GUARANTEED;
  STime := timeGetTime;
  for x := 0 to 9 do
  begin  // 10 Datenpakete mit DataSize Bytes
    PData^.dwSeqNumber := x;
    DPlayer.Send(DPID_ALLPLAYERS,SendFlags,PData,DSize);
  end;
  ChatBox.Items.Add(Format('%d Bytes in %d msec gesendet '+
    '(%d Bytes/sec)',[DSize*10,timeGetTime-STime,
      (DSize*10*1000) div (timeGetTime-STime)]));
  FreeMem(PData);
end;

end.


