unit DXTrashBinU;  // 20-OCT-98 as (Arne Schpers)
{ Oberflche fr die zeitgeistige Version eines Papierkorbs;
  reagiert auf Drag & Drop, fhrt aber keine echten
  Lschaktionen aus.

  Vorausgesetzt werden die DirectX-Header von Erik Unger und
  DirectX 6 bzw. DirectX 5 und die von mir per IFDEF auf
  DirectX 5 zurckgedrehte Version der Unit DDraw.
}

interface
{$DEFINE DIRECTX5} // sonst ist DirectX gefordert!
uses
  Windows, Messages, SysUtils, Classes, Graphics,
  Controls, Forms, Dialogs, StdCtrls, ExtCtrls, Menus,
  ShellAPI,  // DragAcceptFiles
  DDraw,     // Header von Erik Unger
  DXDrawAS,  // DirectDraw-Komponenten
  DXTimer,   // guess what
  MMSystem,  // Zeitmessung
  DXTrashBin2ndFormU;  // zweites Fenster

const
//  FIREWIDTH = 200; FIREHEIGHT = 200;
  FIREWIDTH = 50; FIREHEIGHT = 150;
  FIRECALCHEIGHT = FIREHEIGHT+3;
type
  TTrashBinForm = class(TForm)
    rThreads: TRadioGroup;
    lTiming: TLabel;
    lStatus: TLabel;
    MainMenu: TMainMenu;
    mSettings: TMenuItem;
    cVidMem: TMenuItem;  // FireSurf: Haupt- oder Bildspeicher
    cText: TMenuItem;    // Canvas.TextOut ja/nein
    cSafecopy: TMenuItem; // SafeCopy ja/nein
    cDIB: TMenuItem;      // statisches DIB zum Vergleich
    cAdvanceFire: TMenuItem;
    cWindow2: TMenuItem;
    cBltASYNC: TMenuItem;  // Feuer weiterberechnen
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure FormPaint(Sender: TObject);
    procedure rThreadsClick(Sender: TObject);
    procedure SettingsClick(Sender: TObject);
  protected  // Reaktion auf Drags aus dem Explorer
    procedure WMDropFiles(var Msg: TMessage); message WM_DROPFILES;
  protected  // die DirectDraw-Ecke
    function InitDirectDraw: Boolean;
    procedure ExitDirectDraw;
    procedure LoadSurfaces;
    function RestoreSurfaces: Boolean;
  private  // DirectDraw-Objekte
    PrimarySurf, FireSurf: TDDSurface;
    FireTop, FireLeft: Integer;
    DIB: TBitmap;  // statisches DIB zum Vergleich
  private // Timer
    FireTimer, AnotherTimer: TDXTimer;
    procedure FireTimerSync(Sender: TObject);
    procedure FireTimerAsync(Sender: TObject);
    procedure AnotherTimerSync(Sender: TObject);
  private
    FileCount, FilesProcessed: Integer;
    // "Hitze" des Feuers - ein Byte pro Pixel
    FireData: Array[0..FIRECALCHEIGHT,0..FIREWIDTH-1] of Byte;
    // Umsetzung 0..255 in Pixelwerte, d.h. Farben
    FirePal: Array[0..255] of DWORD;
    // Hitzeverteilung weiterrechnen
    CoolingFactor, HeatFactor: Integer;
    CoolingTab: Array[0..255] of Integer;
    procedure AdvanceFire(StepCount: Integer);
    procedure FireToFireSurf;  // -> Farbwerte -> Oberflche
    procedure BuildFirePal;  // FirePal besetzen
  protected  // Palettenkram
    OurPal: HPalette;
    function GetPalette: HPalette; override;
    procedure OnDeactivateApp(Sender: TObject);
    procedure OnActivateApp(Sender: TObject);
  end;

var TrashBinForm: TTrashBinForm;

implementation
{$R *.DFM}

function TTrashBinForm.GetPalette: HPalette;
begin
  Result := OurPal;
end;

procedure TTrashBinForm.OnDeactivateApp(Sender: TObject);
begin // Auskommentieren, wenn Pause in allen Modi gewnscht
{//}  if OurPal = 0 then Exit;
  FireTimer.Enabled := False; AnotherTimer.Enabled := False;
  Invalidate;
end;

procedure TTrashBinForm.OnActivateApp(Sender: TObject);
begin  // Auskommentieren, wenn Pause in allen Modi gewnscht
{//} if OurPal = 0 then Exit;
 FireTimer.Enabled := cAdvanceFire.Checked; rThreadsClick(Self);
end;

procedure TTrashBinForm.FormCreate(Sender: TObject);
begin
  lStatus.Caption := 'Idle'; lTiming.Caption := '';
  FireLeft := 0;
  FireTop := rThreads.Top+rThreads.Height+10;
  if FIREWIDTH < rThreads.Width+8
    then ClientWidth := rThreads.Width+8
    else ClientWidth := FIREWIDTH;
  ClientHeight := FireTop+FIREHEIGHT;
  DragAcceptFiles(Handle,True);  // Drag & Drop
  CoolingFactor := 10; HeatFactor := 10;
  FireTimer := TDXTimer.Create(Self);
  // Wahlpunkte im Men "Settings"
  cAdvanceFire.Checked := True;  // Timer ist an
  cVidMem.Checked := True;  // FireSurf im Bildspeicher

  with FireTimer do
  begin
    Interval := 30; Enabled := True;
    OnTimer := FireTimerSync; // Vordergrund
    OnAsyncTimer := FireTimerAsync;  // Hintergrund: Berechnung
  end;
  // simuliert eine weitere Beschftigung
  AnotherTimer := TDXTimer.Create(Self);
  with AnotherTimer do
  begin
    Interval := 30; Enabled := False;
    OnTimer := AnotherTimerSync;
  end;
  // DIB zum Vergleich
  DIB := TBitmap.Create;
  DIB.Width := FIREWIDTH; DIB.Height := FireHeight;
  with DIB, DIB.Canvas do
  begin
    PolyLine([Point(0,0), Point(Width,Height), Point(0,Height),
         Point(Width,0), Point(0,0)]);
    TextOut(Width div 2 - 10, Height div 2, 'DIB');
  end;
// DIB.HandleType := bmDDB;  // bringt fast nix (5%)

  RThreadsClick(Self);  // eine Aktion
  if not InitDirectDraw then PostQuitMessage(0);
  Application.OnDeactivate := OnDeactivateApp;
  Application.OnActivate := OnActivateApp;
end;

procedure TTrashBinForm.FormDestroy(Sender: TObject);
begin
  DIB.Free;
  if OurPal <> 0 then DeleteObject(OurPal);
  // DirectDrawUninitialize luft per DXDrawAS.finalization
end;

// die diversen Einstellmglichkeiten ber das Men
procedure TTrashBinForm.SettingsClick(Sender: TObject);
begin
  with Sender as TMenuItem do
  begin
    Checked := not Checked; // fr cDIB und cText wars das schon
    if Sender = cAdvanceFire then FireTimer.Enabled := Checked;
    if Sender = cWindow2 // zweites Fenster
      then DXTrashBin2ndForm.Visible := Checked;
  end;
  if Sender = cSafeCopy then
  begin  // mit oder ohne SafeCopy
    ExitDirectDraw; InitDirectDraw;
  end;
  if Sender = cVidMem then
  begin   // FireSurf im Haupt- oder Bildspeicher
    LoadSurfaces; FireToFireSurf;
  end;
end;

// XRef: FormCreate, RestoreSurfaces
function TTrashBinForm.InitDirectDraw: Boolean;
begin
  Result := False;
  try
    // primre Oberflche, keine nderung des Videomodus,
    // Clipper fr dieses Fenster, UseSafeCopy ja/nein
    DirectDrawInitialize(nil, DDSCL_NORMAL, Handle,
      cSafeCopy.Checked, True);  // Idlecheck in beiden Modi
    // primre Oberflche, Clipper damit verbinden
    PrimarySurf := CreatePrimarySurface(Handle);
    // weitere (in diesem Fall eine) Oberflchen anlegen
    LoadSurfaces;
    Result := True;
  except
    on E: DDrawException do ShowMessage(E.Message);
  end;
end;

procedure TTrashBinForm.ExitDirectDraw;
begin
  DirectDrawUninitialize;
end;

procedure TTrashBinForm.LoadSurfaces;
begin
  FireSurf := TDDSurface.Create(Self);
  with FireSurf.SurfDesc do
  begin
    // soll heien: diese Felder sind besetzt
   dwFlags := DDSD_CAPS or DDSD_HEIGHT or DDSD_WIDTH;
   // 50*150 Pixel, Haupt- oder Bildspeicher
   dwWidth := FIREWIDTH; dwHeight := FIREHEIGHT;
   if cVidMem.Checked then ddsCaps.dwCaps := DDSCAPS_VIDEOMEMORY
     else ddsCaps.dwCaps := DDSCAPS_SYSTEMMEMORY;
  end;
  FireSurf.SurfaceFromSurfDesc;
  // "Palette" mit Farbwerten im Format der Oberflche
  BuildFirePal;
end;

// Wiederherstellungsversuch der Oberflchen. XRef: FormPaint
function TTrashBinForm.RestoreSurfaces: Boolean;
var Res: HResult;
begin
  // Versuch, die primre Oberflche wiederherzustellen
  Res := PrimarySurf.SurfaceObject._Restore;
  if Res = DDERR_WRONGMODE then
  begin  // Videomodus gendert: komplette Reinitialisierung
    DirectDrawUninitialize;
    Result := InitDirectDraw;
  end
    else Result := SUCCEEDED(FireSurf.SurfaceObject._Restore);
end;

procedure TTrashBinForm.FormPaint(Sender: TObject);
begin
  // DIB-Timing zum Vergleich
  if cDIB.Checked then
  begin
    if cText.Checked then with DIB do
    begin
      Canvas.Brush.Style := bsClear;
      Canvas.TextOut(2,2, Format('Cool: %d',[CoolingFactor]));
    end;
    Canvas.Draw(FireLeft,FireTop,DIB);
    Exit;
  end;

  if DirectDraw = nil then Exit;
  // lebt die primre Oberflche noch?
  if FAILED(PrimarySurf.SurfaceObject.IsLost) then
    if not RestoreSurfaces then Exit;

  if (OurPal <> 0) and not Application.Active then
  with Canvas do
  begin
    Brush.Style := bsClear;
    Font.Name := 'Arial'; Font.Size := 35;
    TextOut(FireLeft,FireTop,'Paused');
    Exit;
  end;
  if cText.Checked then  // Canvas-Demonstration
  with FireSurf do
  begin
    Canvas.Brush.Style := bsClear;
    Canvas.TextOut(2,2, Format('Cool: %d',[CoolingFactor]));
    Canvas.ReleaseDC;  // lebensnotwendig!
  end;

  with PrimarySurf do
  begin
    ClipperWnd := Handle;   // Koordinaten-Umsetzung, Clipper
    if cBltASYNC.Checked then BltFlags := DDBLT_ASYNC
       else BltFlags := 0;
    Draw(FireLeft,FireTop,FireSurf); // Feuer zeichnen
  end;
  // DDraw-Zeichenoperationen auch im zweiten Fenster?
  if cWindow2.Checked then
    DXTrashBin2ndForm.PaintFire(FireLeft, FireTop,
      PrimarySurf, FireSurf);
end;

// Drag & Drop von Dateinamen aus dem Explorer
procedure TTrashBinForm.WMDropFiles(var Msg: TMessage);
var DropHandle: THandle;
begin
  DropHandle := Msg.wParam;
  Inc(FileCount,DragQueryFile(DropHandle, Cardinal(-1), nil, 0));
  DragFinish(DropHandle);  // Abschlu: Freigabe des Handles
  Msg.Result := 0;
  SetActiveWindow(Handle);
  // der nchste Durchlauf des synchronen Timers heizt an...
  if not cAdvanceFire.Checked then SettingsClick(cAdvanceFire);
end;

procedure TTrashBinForm.BuildFirePal;
const RGBs:  Array[0..3] of TPaletteEntry =
  ((peRed: 0; peGreen: 0; peBlue: 0),
   (peRed: 150; peGreen: 32; peBlue: 59),
   (peRed: 241; peGreen: 166; peBlue: 0),
   (peRed: 255; peGreen: 255; peBlue: 96)
  );
var x,y, Color: Integer; R,G,B: Integer;
  LogPal: TMaxLogPalette;
begin
  Color := ColorToRGB(Self.Color);
  with RGBs[0] do
  begin  // eigene Hintergrundfarbe als Startpunkt einsetzen
    peRed := GetRValue(Color); peGreen := GetGValue(Color);
    peBlue := GetBValue(Color);
  end;
  for x := 0 to 2 do
    for y := 0 to 84 do
    begin
      R := (RGBs[x].peRed*(84-y)+RGBs[x+1].peRed*y) div 84;
      B := (RGBs[x].peBlue*(84-y)+RGBs[x+1].peBlue*y) div 84;
      G := (RGBs[x].peGreen*(84-y)+RGBs[x+1].peGreen*y) div 84;

      with FireSurf.SurfDesc.ddpfPixelFormat do
        case dwRGBBitCount of
          8: Color := R + G shl 8 + B shl 16;  // RGB
          16:
            if dwRBitMask = $F800 then // 16 Bit: RGB 565
           Color := (R shr 3) shl 11 + (G shr 2) shl 5 + B shr 3
           else Color := (R shr 3) shl 10  // RGB 555
              + (G shr 3) shl 5 + B shr 3;
          24,32:
            Color := B + G shl 8 + R shl 16;  // BGR
          else
            Color := 0;
        end;
      FirePal[x*85+y] := Color;
  end;
  if FireSurf.SurfDesc.ddpfPixelFormat.dwRGBBitCount = 8 then
  begin  // globale Palette anlegen. In den meisten Programmen
    // drfte das etwas einfacher gehen, nmlich mit
    // DirectDrawCreatePalette(SomeProgramTBitmap.Palette);
    with LogPal do
    begin
      palVersion := $300; palNumEntries := 256;
      Move(FirePal,palPalEntry[0],256*SizeOf(Integer));
    end;
    OurPal := CreatePalette(PLogPalette(@LogPal)^);
    DirectDrawCreateGlobalPalette(OurPal);
    // Umsortieren von FirePal in Palettenindices. Die ersten
    // und letzten 10 Eintrge werden von Windows beansprucht.
    for x := 0 to 255 do FirePal[x] := 10+ (x * 236) div 255;
  end;
end;

procedure TTrashBinForm.rThreadsClick(Sender: TObject);
begin
  AnotherTimer.Enabled := rThreads.ItemIndex <> 0;
  lTiming.Visible := AnotherTimer.Enabled;
  Invalidate;
end;

// Gibt dem Vordergrund-Thread was zu tun (Form vergrern!)
procedure TTrashBinForm.AnotherTimerSync(Sender: TObject);
var FireCount, STime: Cardinal;
begin
  FireCount := 0; STime := timeGetTime;
  while FireTop < ClientHeight-20 do
  begin
    FireLeft := 0;
    while FireLeft < ClientWidth-20 do
    begin
      // bei 256 Farben und Canvas-Zugriffen kommt bei SafeCopy
      // unter Umstnden sonst gar nichts mehr durch
      Application.ProcessMessages;
      if not AnotherTimer.Enabled then
      begin
        Invalidate; Break;
      end;
      FormPaint(Self);
      Inc(FireLeft,FIREWIDTH); Inc(FireCount);
    end;
    Inc(FireTop,FIREHEIGHT);
  end;
  FireLeft := 0;
  FireTop := rThreads.Top+rThreads.Height+10;
  STime := timeGetTime - STime;
  if FireCount > 0 then lTiming.Caption := Format('%d:%d:%d',
    [FireCount, STime, STime div FireCount]);
  DDIdleCheck;  // Direktaufruf, weil hier keine Nachrichten dabei sind
end;

procedure TTrashBinForm.FireTimerSync(Sender: TObject);
begin
  if DirectDraw = nil then Exit;
  FireToFireSurf;  // -> Oberflche und zeichnen
  if (FileCount <> 0) and (HeatFactor = 10) then
  begin
    Inc(FilesProcessed);
    if FilesProcessed > FileCount then
    begin
      lStatus.Caption := 'Idle';
      FileCount := 0; FilesProcessed := 0;
    end else
    begin  // nchste Datei "bearbeiten"
      HeatFactor := 1; CoolingFactor := 999;
      lStatus.Caption := Format('Burning file %d...',
        [FilesProcessed]);
    end;
  end;
  DDIdleCheck;  // Direktaufruf - keine Nachrichten hier
end;

procedure TTrashBinForm.FireTimerAsync(Sender: TObject);
begin
  AdvanceFire(3);  // im Hintergrund
end;

procedure TTrashBinForm.AdvanceFire(StepCount: Integer);
var x,y,z: Integer;
begin
  for z := 1 to StepCount do
  begin
    // "Hitzeverteilung" wird von oben nach unten berechnet:
    //  .   y  .       ->     neues y = (y+x1+x2+x3) div 4
    //  x1 x2 x3
    for y := 0 to FIRECALCHEIGHT-1 do
      for x := 1 to FIREWIDTH-2 do
        FireData[y,x] := (FireData[y,x] + FireData[y+1,x-1] +
           FireData[y+1,x] + FireData[y+1,x+1]) div 4;

    // Abkhlung luft * 999 div 1000 bis *9 div 10
    if CoolingFactor > 9 then
    begin
     if CoolingFactor > 100 then Dec(CoolingFactor,3)
      else Dec(CoolingFactor);
     if CoolingFactor < 9 then CoolingFactor := 9;
     for x := 0 to 255 do
       CoolingTab[x] := x * CoolingFactor div (CoolingFactor+1);
    end;
    // Abkhlung jeder vierten Zeile (willkrlich gewhlt)
    y := 0; while y < FIRECALCHEIGHT do
    begin
      for x := 0 to FIREWIDTH-1 do
        FireData[y,x] := CoolingTab[FireData[y,x]];
      Inc(y,4);
    end;
    // Unterste Zeile kriegt eine Extra-Abkhlung
    for x := 0 to FIREWIDTH-1 do
      FireData[FIRECALCHEIGHT-1,x] :=
        FireData[FIRECALCHEIGHT-1,x] * 9 div 10;
    // "Zufllige" Verteilung neuer Hitzequellen
    for x := 10 to FIREWIDTH-1-10 do
      if Random(HeatFactor+1) = 1 then
       for y := 0 to 4 do
       begin
        FireData[FIRECALCHEIGHT-1,x+y] := 128*(8-y) div 4-1;
        FireData[FIRECALCHEIGHT-1,x-y] := 128*(8-y) div 4-1
       end;

    if (CoolingFactor = 9) and (HeatFactor < 10)
      then Inc(HeatFactor);  // "abgebrannt"
  end;
end;

procedure TTrashBinForm.FireToFireSurf;
type B3 = Array[0..2] of Byte; B4 = Array[0..3] of Byte;
     PRGB = ^B3; PQUAD = ^B4;
var x,y: Integer; Bits: PByte; PFireData: PByte; Step: Integer;
begin
  Bits := FireSurf.LockBits;
  Step := FireSurf.SurfDesc.ddpfPixelFormat.dwRGBBitCount div 8;
  for y := 0 to FIREHEIGHT-1 do
  begin
    PFireData := @FireData[y,0];
    case Step of
     1: for x := 0 to FIREWIDTH-1 do
        begin  // FireData = Palettenindices
          Bits^ := FirePal[PFireData^];
          Inc(PFireData); Inc(Bits);
        end;
     2: for x := 0 to FIREWIDTH-1 do
        begin
          PWord(Bits)^ := FirePal[PFireData^];
          Inc(PFireData); Inc(Bits,2);
        end;
     3: for x := 0 to FIREWIDTH-1 do
        begin
          PRGB(Bits)^ := PRGB(@FirePal[PFireData^])^;
          Inc(PFireData); Inc(Bits,3);
        end;
     4: for x := 0 to FIREWIDTH-1 do
        begin
          PQUAD(Bits)^ := PQUAD(@FirePal[PFireData^])^;
          Inc(PFireData); Inc(Bits,4);
        end;
    end;
    Inc(Bits,FireSurf.Pitch-FIREWIDTH*STEP); // nchste Zeile
  end;
  FireSurf.UnlockBits(True);
  FormPaint(Self);
end;

end.





