VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "clsEvents"
Attribute VB_GlobalNameSpace = True
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = True
Option Explicit
'**************************************************
' Ein Ereignis, das auf dem Client ausgelst wird
'**************************************************
Public Event OnAppMessage(ByVal MessageID As Long, ByVal MessageTag As Long)

'**************************************************
' Methode innerhalb der Komponente, um ein Ereignis
' weiterzureichen und auf den Clients auszulsen
'**************************************************
Friend Sub RaiseAppMessage(ByVal MessageID As Long, ByVal MessageTag As Long)
  On Error GoTo RaiseAppMessageErr
  
  RaiseEvent OnAppMessage(MessageID, MessageTag)

RaiseAppMessageExit:
  On Error Resume Next
  Exit Sub
RaiseAppMessageErr:
  'put your debug stuff here
  #If ver_debug Then
    Debug.Print "Error@clsEvents.RaiseAppMessage.Line:"; Erl; Err.Number; Err.Description
  #End If
  Resume RaiseAppMessageExit
End Sub

'**************************************************
' Eine Methode, die vom Client aufgerufen wird, um
' eine Nachricht an alle anderen Clients weiterzuleiten
'**************************************************
Public Function DispatchMessage(ByVal MessageID As Long, ByVal MessageTag As Long)
  On Error GoTo DispatchMessageErr
  
  RaiseEvents MessageID, MessageTag
  
DispatchMessageExit:
  On Error Resume Next
  Exit Function
DispatchMessageErr:
  'put your debug stuff here
  #If ver_debug Then
    Debug.Print "Error@clsEvents.DispatchMessage.Line:"; Erl; Err.Number; Err.Description
  #End If
  Resume DispatchMessageExit
End Function

Private Sub Class_Initialize()
  
  '**************************************************
  ' Das Objekt fgt sich selber der Sammlung aller
  ' instanzierten Objekte hinzu
  '**************************************************
  AddMessageObject Me
  
End Sub

Private Sub Class_Terminate()
  On Error GoTo Class_TerminateErr
  
  '**************************************************
  ' Hier entfernt es sich einfach wieder
  '**************************************************
  RemoveMessageObject Me

Class_TerminateExit:
  On Error Resume Next
  Exit Sub
Class_TerminateErr:
  'put your debug stuff here
  #If ver_debug Then
    Debug.Print "Error@clsEvents.Class_Terminate.Line:"; Erl; Err.Number; Err.Description
  #End If
  Resume Class_TerminateExit
End Sub
