package de.jockels.forcetouchemu;

import android.view.MotionEvent;
import android.view.View;

/**
 * Created by jow on 05.02.2016.
 */
public abstract class OnForceTouchListener3 implements View.OnTouchListener, View.OnLongClickListener, View.OnClickListener {
    boolean mWasForceClick;
    View.OnClickListener mClick;
    View.OnLongClickListener mLong;

    @Override
    public boolean onTouch(View view, MotionEvent ev) {
        if (ev.getAction() == MotionEvent.ACTION_DOWN) {
            mWasForceClick = false;

            if (mClick==null) mClick = new View.OnClickListener() {
                @Override
                public void onClick(View view) {
                    if (mWasForceClick)
                        OnForceTouchListener3.this.onForceClick(view);
                    else
                        OnForceTouchListener3.this.onClick(view);
                }
            };

            if (mLong==null) mLong = new View.OnLongClickListener() {
                @Override
                public boolean onLongClick (View view){
                    if (mWasForceClick)
                        return OnForceTouchListener3.this.onForceClick(view);
                    else
                        return OnForceTouchListener3.this.onLongClick(view);
                }
            };

            view.setOnClickListener(mClick);
            view.setOnLongClickListener(mLong);
        }

        if (ForceTouchHelper.isForceTouch(ev))
            mWasForceClick = true;

        return false;
    }

    public abstract boolean onForceClick(View view);

}
