/*
    Automatisiertes Starten des Microsoft Flugsimulators FSX:SE Steam Edition
    bb, Feb.2016
    
    Bitte in Zeile 15 einen gespeicherten Flug (*.FLT) einsetzen.
    Bei Einsatz mit einem anderen Steam-Spiel die Variablen
    exepfad, spielexe und parameter entsprechend anpassen.
    Als Administrator starten!
*/

dquote = "
steampfad = %A_ProgramFiles%\Steam\              ; ggbf. anpassen
loginusers = %steampfad%config\loginusers.vdf
loginuserb = %steampfad%config\loginusers.bak

RegRead, exepfad, HKCU, Software\Microsoft\Microsoft Games\Flight Simulator\10.0, AppPath
spielexe = FSX.exe                ; hier anderes Spiel und Pfad eintragen

; bei deutschsprachigem FSX muss Ordner heien: "Flight Simulator X-Dateien" und
; fr "Eigenes.FLT" einen existierenden gespeicherten Flug einsetzen:
flightdatei = %A_MyDocuments%\Flight Simulator X Files\Eigenes.FLT
parameter = "%flightdatei%"       ; Weil Pfad Leerzeichen enthlt, muss Run-Parameter mit Anfhrungs-
                                  ;  zeichen umschlossen sein; daher Zuweisung ohne ":", wodurch
                                  ;  Anfhrungszeichen mit in den String wandern 
If Dateilesen(lgu_inhalt, loginusers )        ; Lesefehler bei der Konfigdatei?
   Abbruch("kann loginusers.vdf nicht finden/ffnen")

Process, Exist, Steam.exe                     ; Luft Steam noch?
If !Errorlevel                                ; Nur wenn Steam noch nicht luft,
{                                             ;  die Config-Datei patchen
  pos := InStr(lgu_inhalt, "WantsOfflineMode"	. dquote . A_Tab . A_Tab . dquote)
  If !pos                                     ; hat Valve Struktur gendert?
     Abbruch("Datei loginusers.vdf hat sich bei WantsOfflineMode= gendert")
  lgu_inhalt := SubStr(lgu_inhalt, 1, pos + 19) . "1" . SubStr(lgu_inhalt, pos + 21)
  
  pos := InStr(lgu_inhalt, "SkipOfflineModeWarning" . dquote . A_Tab . A_Tab . dquote)
  If !pos
     Abbruch("Datei loginusers.vdf hat sich gendert")
  lgu_inhalt := SubStr(lgu_inhalt, 1, pos + 25) . "1" . SubStr(lgu_inhalt, pos + 27)
  
  FileMove, %loginusers%, %loginuserb%, 1      ; 1 = vorhandes Bak berschreiben
  FileAppend, %lgu_inhalt%, %loginusers%
}

;;;Msgbox, Loginusers.vdf erfolgreich gendert  ;*!!!nur zum Testen

Run, %exepfad%%spielexe% %parameter%              ; Start des FSX:SE, wodurch
                                               ;  auch der Steam-Client gestartet wird;

; wenn englisches Windows, dann vermutlich auch englischer Steam-Client; 
; bei anderer Konstellation bitte Zuweisung anpassen:
If A_Language = 0407                           ; deutsches Windows?
   wintitel = Spielstart zulassen
 Else                                          ; nein, englisches
   wintitel = Allow game launch
Loop                                           ; warten, 
{ IfWinExist, %wintitel%                       ;  bis Steam-Dialog erscheint
  { WinActivate, ahk_pid Steam.exe, %wintitel% ; Das fr alle Flle
    Sleep, 1000                                ; Eine Verzgerung ist notwendig
    SendInput {Enter}                          ; Zur Zeit ist "OK" Defaultbox 
    Break                                      ; Falls nicht, besser mit Befehl Click X,Y arbeiten
  }
}

Ende:
ExitApp

; *---------------- Funktionen --------------*
Abbruch(fehlertxt)
{ MsgBox, Programmabbruch - %fehlertxt%
  Gosub, Ende
}
Dateilesen(ByRef dateiinh, dateiname)      ; Datei in Variable einlesen
{ FileRead, dateiinh, %dateiname%
  Return Errorlevel
}

/*
Die Datei loginusers.vdf:

"users"
{
	"76561198005194673"
	{
		"AccountName"		"Ihr Nickname"
		"PersonaName"		"Benutzername"
		"RememberPassword"		"1"
		"Timestamp"		"1447168217"
		"WantsOfflineMode"		"1"
		"SkipOfflineModeWarning"		"1"
	}
}
*/