#!/usr/bin/env python

import socket, json

BUFFER_SIZE = 4096
MSG = { 'cmd': 'load','url': 'http://www.ct.de/' }

with socket.socket(socket.AF_INET, socket.SOCK_STREAM) as sock:
  sock.connect(('127.0.0.1', 44444))
  sock.send(json.dumps(MSG).encode('utf-8'))
  while True:
    data_in = sock.recv(BUFFER_SIZE)
    reply = json.loads(data_in.decode('utf-8'))
    if 'title' in reply:
      print('document title: %s' % reply['title'])
    if 'url' in reply and reply['url'] != MSG['url']:
      print('redirected from %s to %s.' % (MSG['url'], reply['url']))
    if 'dt' in reply:
      print('load time: %.1f ms' % reply['dt'])
    if 'cmd' in reply and reply['cmd'] == 'exit':
        break
