/*
 * Copyright (c) 2015 Oliver Lau <ola@ct.de>, Heise Medien GmbH & Co. KG
 * All rights reserved.
 */

(function(window) {
  var host = "de.ct.chromote";
  var portToProxy = null;
  var t0 = null;

  function onMessageFromProxy(msg) {
    if (msg.cmd === "load") {
      t0 = window.performance.now();
      chrome.tabs.update(window.WINDOW_ID_CURRENT, { url: msg.url });
    }
    else {
      // XXX: simple echo for debugging purposes
      port.postMessage(msg);
    }
  }

  function onProxyDisconnected() {
    console.log("Disconnected. " + chrome.runtime.lastError.message);
    portToProxy = null;
  }

  function onPageCompleted(page) {
    var dt = window.performance.now() - t0;
    var onContentMessage = function(reply) {
      if (reply) {
        var response = { dt: dt, url: reply.url, title: reply.title };
        if (portToProxy)
          portToProxy.postMessage(response);
      }
    };
    chrome.tabs.sendMessage(page.tabId, { cmd: "get-document-info" }, onContentMessage);
  }

  function main() {
    console.log("%c c't Chromote %c - This Chrome extension gets remotely controlled by a Python script.",
                "background-color: #0061af; color: white; font-weight: bold; letter-spacing: 5px",
                "color: #0061af; font-weight: bold;");
    console.log("%cCopyright (c) 2015 Oliver Lau, Heise Medien GmbH & Co. KG. All rights reserved.",
                "color: #aaa");

    portToProxy = chrome.runtime.connectNative(host);
    portToProxy.onMessage.addListener(onMessageFromProxy);
    portToProxy.onDisconnect.addListener(onProxyDisconnected);

    chrome.webNavigation.onCompleted.addListener(onPageCompleted);

    chrome.extension.onConnect.addListener(function popupListener(portToPopup) {
      portToPopup.onMessage.addListener(function(msg) {
        if (msg.cmd === "get-proxy-connection-status") {
          portToPopup.postMessage({ "proxy-connection-status": portToPopup !== null ? "connected" : "disconnected" });
        }
      });
    });
  }

  document.addEventListener("DOMContentLoaded", main);

})(window);
