/*****************/
/* 28.06.2015    */
/* Kai-Uwe Mrkor */
/*****************/

#include <pebble.h>
#include <string.h>

  
  
static Window *window;
static ScrollLayer *scroll_layer;
static TextLayer *spickertext_layer,  *time_layer;
static bool uhrzeitAnzeigen = true;



static char spickertext[] = "Facebook\n"
                            "-------------\n"
                            "IExpl: ALT+x\n"
                            "FiFox: ALT+Shift+x\n"
                            "Mac: Fkt+Ctr+xl\n\n"
  
                            "M: Neue Nachricht\n"
                            "?: Suche\n"
                            "1: News Feed-Home\n"
                            "2: Profilseite\n"
                            "3: FreundAnfragen\n"
                            "4: Nachrichten\n"
                            "5: Mitteilungen\n"
                            "6: Account-Einst.\n"
                            "7: Privat-Einst.\n"
                            "8: Facebook-Seite\n"
                            "9: Profilseite\n"
                            "0: Hilfe-Center\n\n"
   
  
                            " Twitter\n"
                            " ----------\n"
                            " g h: Homepage\n"
                            " g p: Profil\n"
                            " g m: Nachrichten\n"
                            " n: Neuer Tweet\n"
                            " m: dir. Nachricht\n"
                            " f: Favorisieren\n"
                            " t: ReTweet\n"
                            " r: Replay\n"
                            " j: Nächster Tweet\n"
                            " k: Vorher. Tweet\n"
                            " ?: Shortcut-Liste\n\n"

  
                            " Xing (Shift+x)\n"
                            " -------------------\n"
                            " k: Kontakte\n"
                            " s: Suche\n"
                            " h: Hilfe\n"
                            " m: Einladen\n"
                            " l: Ausloggen\n"
                            " n: Neue Nachricht\n"
                            " i: Posteingang\n"
                            " d: Teilen\n"
                            " o: Einstellungen\n"
                            " x: Startseite\n"
                            " j: Jobs\n"
                            " p: Projekte\n"
                            " t: Themen\n"
                            " e: Events\n"
                            " u: Unternehmen\n";



//
// Uhren-Event
//
static void tick_handler(struct tm *tick_time, TimeUnits units_changed) {

  // Puffer zur Ablage der Uhrzeit erzeugen
  static char buffer[] = "00:00";

  // Uhrzeit ausgeben
  strftime(buffer, sizeof("00:00"), "%H:%M", tick_time);
  text_layer_set_text(time_layer, buffer);        
}


//
// Event der Select-Taste
// Umschaltung zwischen Anzeige der Uhrzeit und dem Text des "Spickers"
//
static void select_click_handler(ClickRecognizerRef recognizer, void *context) {  
    
  
  if (uhrzeitAnzeigen){
    
      // Anzeige der Uhrzeit wird beendet
      // Spickertest wird angezeigt    
      layer_set_hidden((Layer *)time_layer, true);    
      layer_set_hidden((Layer *)spickertext_layer, false);        
    
      uhrzeitAnzeigen = false;
  }
  else {
    
      // Anzeige des Spickers wird beendet
      // Uhrzeit wird angezeigt
      layer_set_hidden((Layer *)time_layer, false);
      layer_set_hidden((Layer *)spickertext_layer, true);    
      
      uhrzeitAnzeigen = true;
 } 
}


//
// Tastendruck nach oben (Spickertext nach oben scrollen)
//
static void up_click_handler(ClickRecognizerRef recognizer, void *context) {
  
   if (!uhrzeitAnzeigen){
     GPoint offset = scroll_layer_get_content_offset(scroll_layer);
     offset.y = offset.y + 23;
     scroll_layer_set_content_offset	(scroll_layer, offset, false);
   }
}


//
// Tastendruck nach unten (Spickertext nach unten scrollen)
//
static void down_click_handler(ClickRecognizerRef recognizer, void *context) {

  if (!uhrzeitAnzeigen){
     GPoint offset = scroll_layer_get_content_offset(scroll_layer);
     offset.y = offset.y - 23;
     scroll_layer_set_content_offset	(scroll_layer, offset, false);
  }
}


//
// Einrichtung der Event-Handler für die drei rechten Tasten
//
static void click_config_provider(void *context) {
  
  window_single_click_subscribe(BUTTON_ID_SELECT, select_click_handler);
  window_single_click_subscribe(BUTTON_ID_UP, up_click_handler);
  window_single_click_subscribe(BUTTON_ID_DOWN, down_click_handler);
}


//
// Fenster erzeugen und Kindelemente einfügen
//
static void window_load(Window *window) {
    
  const GRect max_text_bounds = GRect(0, 0, 144, 20000); // 20000 pixels of text
  

  // ------------------
  // --  Uhrzeit     --
  // ------------------
  
  // Text-Layer für die Uhrzeit
  time_layer = text_layer_create(GRect(0, 55, 144, 50));  
  text_layer_set_background_color(time_layer, GColorWhite);
  text_layer_set_text_color(time_layer, GColorBlack);

  // Schriftart und Ausrichtung der Uhrzeit einrichten
  text_layer_set_font(time_layer, fonts_get_system_font( FONT_KEY_ROBOTO_BOLD_SUBSET_49));  //   FONT_KEY_BITHAM_42_BOLD
  text_layer_set_text_alignment(time_layer, GTextAlignmentCenter);

  // Kindfenster zufügen 
  layer_add_child(window_get_root_layer(window), text_layer_get_layer(time_layer));  
  
  
  // ------------------
  // -- Spicker-Text --
  // ------------------  
  
  scroll_layer = scroll_layer_create( GRect(0,0,144,168));  
  scroll_layer_set_content_size( scroll_layer,  max_text_bounds.size);
  
  // Text-Layer erzeugen 
  spickertext_layer = text_layer_create( max_text_bounds);  
  text_layer_set_font(spickertext_layer, fonts_get_system_font( FONT_KEY_GOTHIC_24_BOLD));
  
  // spickertext_layer zum scroll_layer zufügen  
  scroll_layer_add_child( (ScrollLayer *)scroll_layer, text_layer_get_layer(spickertext_layer) );
  
  // Kindfenster zufügen 
  layer_add_child(window_get_root_layer(window), scroll_layer_get_layer(scroll_layer));  
  
  // Der Spickertext wird erst einmal ausgeblendet
  layer_set_hidden((Layer *)spickertext_layer, true);  
  
  // Zuordnung der Tasten
  window_set_click_config_provider(window, (ClickConfigProvider)click_config_provider);

  // Spickertext übergeben
  text_layer_set_text(spickertext_layer, spickertext);
}


//
// Fenster abbauen
//
static void window_unload(Window *window) {
  scroll_layer_destroy(scroll_layer);
  text_layer_destroy(time_layer);
  text_layer_destroy(spickertext_layer);
}


//
// Initialisierung aller Komponenten
//
static void init(void) {
  
  // Fenster 
  window = window_create();
  window_set_fullscreen(window, true);  
  
  // Handler für das Einrichten und Abbauen des Fensters festlegen
  window_set_window_handlers(window, (WindowHandlers) {
	  .load = window_load,
    .unload = window_unload,
  });
      
  // Tick-Timer anmelden (löst jede Sekunde ein Event aus)
  tick_timer_service_subscribe(SECOND_UNIT, tick_handler);
     
  // 
  const bool animated = true;
  window_stack_push(window, animated);  
}


//
// Fenster wieder abbauen
//
static void deinit(void) {
  
  window_destroy(window);
}


//
// Das Hauptprogramm (Eintrittspunkt bei jedem Start der App)
//
int main(void) {
 // APP_LOG(APP_LOG_LEVEL_INFO, "main gestartet");
  init();
  app_event_loop();
  deinit();
 // APP_LOG(APP_LOG_LEVEL_INFO, "main beendet");
}