﻿using System;
using System.Collections.Generic;
using System.Runtime.Serialization;
using System.Text;
using System.Linq;
using Windows.Web.Syndication;
using System.Text.RegularExpressions;

namespace FeedReader.Model
{
    [DataContract]
    public class FeedItem : IEqualityComparer<FeedItem>, IEquatable<FeedItem>
    {
        public FeedItem(SyndicationItem item)
        {
            Title = item.Title.Text;
            Date = item.PublishedDate;
            ItemUri = item.Links[0].Uri;
            SummaryHtml = item.Summary.Text;
            SummaryText = Regex.Replace(item.Summary.Text, "<[^>]*>", "").Trim();
            Summary = item.NodeValue;
        }
        internal static FeedItem Import(SyndicationItem item)
        {
            return new FeedItem(item);
        }

        [DataMember(Name="Title")]
        public string Title { get; set; }

        [DataMember(Name = "Date")]
        public DateTimeOffset Date { get; set; }
        
        [DataMember(Name = "ItemUri")]
        public Uri ItemUri { get; set; }
        
        [DataMember(Name = "Summary")]
        public string Summary { get; set; }


        [DataMember(Name = "SummaryHtml")]
        public string SummaryHtml { get; set; }

        [DataMember(Name = "SummaryText")]
        public string SummaryText { get; set; }

        public bool Equals(FeedItem item1, FeedItem item2)
        {
            return Uri.Equals(item1.ItemUri, item2.ItemUri);
        }

        public int GetHashCode(FeedItem obj)
        {
            return obj.ItemUri.GetHashCode();
        }

        public int CompareTo(object obj)
        {
            return 0;
        }

        public bool Equals(FeedItem other)
        {
            return Equals(this, other);
        }
    }
}
