﻿using System;
using System.Collections.Generic;
using System.Runtime.Serialization;
using System.Text;
using Windows.Web.Syndication;

namespace FeedReader.Model
{
    [DataContract]
    [KnownType(typeof(FeedItem))]
    public class Feed
    {
        public Feed(SyndicationFeed feed)
        {
            Title = feed.Title.Text;
            Items = new List<FeedItem>();
            foreach (var item in feed.Items)
            {
                Items.Add(FeedItem.Import(item));
            }
        }


        [DataMember(Name = "Title")]
        public String Title { get; set; }

        [DataMember(Name = "Items")]
        public List<FeedItem> Items
        {
            get;
            set;
        }

        public static Feed Import(SyndicationFeed feed)
        {
            return new Feed(feed);
        }

    }
}
