﻿using System;
using System.Collections.Generic;
using System.Text;
using Windows.UI.Xaml;
using Windows.UI.Xaml.Data;

namespace FeedReader.Converter
{
    public class BooleanToVisibilityConverter : IValueConverter
    {
        public bool Inverted { get; set; }

        public object Convert(object value, Type targetType, object parameter, string language)
        {
            if (value == null || value == DependencyProperty.UnsetValue || !(value is bool))
            {
                return DependencyProperty.UnsetValue;
            }

            var boolValue = (bool)value;
            if (Inverted)
            {
                boolValue = !boolValue;
            }

            return boolValue ? Visibility.Visible : Visibility.Collapsed;
        }

        public object ConvertBack(object value, Type targetType, object parameter, string language)
        {
            if (value == null || value == DependencyProperty.UnsetValue || !(value is Visibility))
            {
                return DependencyProperty.UnsetValue;
            }

            var visibility = (Visibility)value;
            var boolValue = visibility == Visibility.Visible;
            if (Inverted)
            {
                boolValue = !boolValue;
            }

            return boolValue;
        }

    }
}
