#!/usr/bin/python

from os import listdir, stat
from os.path import isfile, join
from operator import itemgetter
from datetime import datetime, timedelta
from time import sleep
import config

import RPi.GPIO as GPIO
import sys, os

MOTIONFILE = "/tmp/letzteregung"
INACTIVITY_TIMEOUT = timedelta(seconds=10*60)
REACTION_TIMEOUT = timedelta(seconds=15)
CHECK_INTERVAL = timedelta(seconds=10)
RETRIES = 5
VERBOSE = 2
GPIOPORT = 17
CAMLED = 5
BUZZER = 22

TRIGGER_PORTS = [ GPIOPORT, CAMLED ]


class Stopwatch:
  def __init__(self):
    self.reset()

  def reset(self):
    dt = self.elapsed()
    self.start_time = datetime.now()
    return dt
        
  def elapsed(self):
    return datetime.now()  - self.start_time

  start_time = datetime.now()

reaction_clock = Stopwatch()
do_quit = False

def motion_detected():
  if not isfile(MOTIONFILE):
    return False
  mtime = stat(MOTIONFILE).st_mtime;
  dt = datetime.now() - datetime.fromtimestamp(mtime)
  motion = dt < INACTIVITY_TIMEOUT
  return motion

def shutdown_system():
  global do_quit
  do_quit = True
  os.system("shutdown now -h")

def trigger(state):
  for port in TRIGGER_PORTS:
    GPIO.output(port, state)

def wake_up():
  if reaction_clock.elapsed() > REACTION_TIMEOUT:
    trigger(GPIO.LOW)
    shutdown_system()
  else:
    trigger(GPIO.HIGH)

def relax():
  global reaction_clock
  trigger(GPIO.LOW)
  reaction_clock.reset()
  sleep(1)

def main():
  GPIO.setmode(GPIO.BCM)
  GPIO.setup(CAMLED, GPIO.OUT)
  GPIO.setup(GPIOPORT, GPIO.OUT)
  GPIO.setup(BUZZER, GPIO.OUT)
  try:
    while do_quit == False:
      if motion_detected(): relax()
      else: wake_up()
  except KeyboardInterrupt:
    pass
  GPIO.cleanup()

if __name__ == "__main__":
    main()
