import requests
from xml.dom import minidom
from requests.auth import HTTPDigestAuth

def build_soap (saction, sservice):
req = u"""<?xml version="1.0"?>
<s:Envelope xmlns:s="http://schemas.xmlsoap.org/soap/envelope/"
s:encodingStyle="http://schemas.xmlsoap.org/soap/encoding/">
<s:Body>
# Dann kommt nochmal der Aufruf, diesmal steht der Funktionsname vorne
<u:{action} xmlns:u={service}>
</u:{action}>
# Und das Ende ist auch immer gleich
</s:Body>
</s:Envelope>""".format(action=saction,service='\"'+sservice+'\"')
return req.encode('utf-8')

#
#
# Part 1 GetSecurityPort
#
#

saction ="GetSecurityPort"
sservice ="urn:dslforum-org:service:DeviceInfo:1"
outtag = "NewSecurityPort"

headers = {"Content-Type":'text/xml; charset="utf-8"',
# "Content-Length": len(encoded_request),
# "SOAPAction": 'urn:dslforum-org:service:DeviceInfo:1#GetSecurityPort'}
"SOAPAction": sservice+'#'+saction}

response = requests.post(url="http://fritz.box:49000/upnp/control/deviceinfo",
headers = headers,
data = build_soap(saction, sservice),
verify=False)

#print response.content #print response.text
r = minidom.parseString(response.content)
#print r.toxml()
sport= r.getElementsByTagName(outtag)[0].firstChild.data
print "SSL port: ", sport
#
# Part 2 GetExternalIPAddress
#
#
saction ="GetExternalIPAddress"
sservice ="urn:dslforum-org:service:WANPPPConnection:1"
outtag = "NewExternalIPAddress"
user="xx"
password ="yy"

headers = {"Content-Type":'text/xml; charset="utf-8"',
# "Content-Length": len(encoded_request),
# "SOAPAction": 'urn:dslforum-org:service:DeviceInfo:1#GetSecurityPort'}
"SOAPAction": sservice+'#'+saction}
# A D A P T URL according to service

response = requests.post(url="https://fritz.box:"+sport+"/upnp/control/wanpppconn1",
auth=HTTPDigestAuth(user, password),
headers = headers,
data = build_soap(saction, sservice),
verify=False)

#print response.content #print response.text
r = minidom.parseString(response.content)
#print r.toxml()
extIP= r.getElementsByTagName(outtag)[0].firstChild.data
print "External IP Address: ", extIP