﻿# Erstmal einen WebClient erzeugen, der später mit der Box spricht
$w=New-Object System.Net.WebClient

# Das Encoding sollte immer UTF8 sein.
$w.Encoding=[System.Text.Encoding]::UTF8

# Eine erste Abfrage ohne SSL
# Auch im http-Header muss stehen, dass die Kommunikation per UTF-8 kodiert ist
$w.Headers.Set("Content-Type", 'text/xml; charset="utf-8"')

# Der Funktionsaufruf kommt in den Header SOAPACTION
$w.Headers.Set("SOAPACTION", 'urn:dslforum-org:service:DeviceInfo:1#GetSecurityPort')

# Der SOAP-Aufruf wird in XML verpackt, und zwar...
# ... beginnt er mit einem immer gleichen Header.
$query='<?xml version="1.0"?>
        <s:Envelope xmlns:s="http://schemas.xmlsoap.org/soap/envelope/"
        s:encodingStyle="http://schemas.xmlsoap.org/soap/encoding/">
        <s:Body> ' +
        # Dann kommt nochmal der Aufruf, diesmal steht der Funktionsname vorne
        '<u:GetSecurityPort xmlns:u="urn:dslforum-org:service:DeviceInfo:1">
        </u:GetSecurityPort>' +
        # Und das Ende ist auch immer gleich
        '</s:Body>
        </s:Envelope>'

# Diese XML-Abfrage schickt der Web-Client mit der Funktion UploadString an die Box.
# Der genaue URL gehört zum Service (siehe Artikel)
# Die Typ-Umwandlung im XML macht aus der Antwort gleich eine Baumstruktur, ...
$r = [xml]$w.UploadString("http://fritz.box:49000/upnp/control/deviceinfo",$query)

# ... in der sich die gesuchte Information über ihren Namen ansprechen lässt.
# In diesem Falle ist das der Port, auf dem die Box einen SSL-gesicherten Zugang für SOAP bietet.
$port=$r.Envelope.Body.GetSecurityPortResponse.NewSecurityPort

# Der WebClient enthält die Antowrt-Header aus der vorigen Abfrage. Daher diese neu setzen:
$w.Headers.Set("Content-Type", 'text/xml; charset="utf-8"')

# Ein anderer Service, eine andere Action
$w.Headers.Set("SOAPACTION", 'urn:dslforum-org:service:WANPPPConnection:1#GetExternalIPAddress')

$query='<?xml version="1.0"?>
        <s:Envelope xmlns:s="http://schemas.xmlsoap.org/soap/envelope/"
        s:encodingStyle="http://schemas.xmlsoap.org/soap/encoding/">
        <s:Body> ' +
        # Auch hier gehören der andere Service und die andere Action hin
        '<u:GetExternalIPAddress xmlns:u="urn:dslforum-org:service:WANPPPConnection:1">
        </u:GetExternalIPAddress>' +
        # Und das Ende ist auch immer gleich
        '</s:Body>
        </s:Envelope>'

# Der WebClient braucht nur die Zugangsdaten, dann wickelt er das Login ganz allein ab.
# dslf-config ist der im TR-64-Standard definierte Name.
$w.Credentials=New-Object System.Net.NetworkCredential("dslf-config","hier muss das Passwort zwischen die Anführungszeichen")

# Das SSL-Zertifikat der Box ist nicht so signiert, dass es der sehr genauen Prüfung im WebClient standhält.
# Daher würde keine Verbindung zu Stande kommen, wenn man nicht die  
# SSL-Zertifikatprüfung für diesen Prozess ausschaltet.
[System.Net.ServicePointManager]::ServerCertificateValidationCallback = {$true}

# Query abschicken. Diesmal sind drei Dinge anders:
# - https statt http
# - Der eben ermittelte Port statt 49000
# - Der URL zum Service (siehe Artikel)
$r = [xml]$w.UploadString("https://fritz.box:"+$port+"/upnp/control/wanpppconn1",$query)

# Wieder steckt die gewünschte Information im XML-Baum.
"Externe IP-Adresse: " + $r.Envelope.Body.GetExternalIPAddressResponse.NewExternalIPAddress

# Nun der Download des Telefonbuchs.
# Dazu muss per Argument das Telefonbuch ausgewählt werden, da die Box mehrere haben kann.
# Dieses Beispiel lädt das erste Telefonbuch herunter.

# Der WebClient enthält die Antwort-Header aus der vorigen Abfrage. Daher diesen neu setzen:
$w.Headers.Set("Content-Type", 'text/xml; charset="utf-8"')

# Ein anderer Service, eine andere Action
$w.Headers.Set("SOAPACTION", 'urn:dslforum-org:service:X_AVM-DE_OnTel:1#GetPhoneBook')

$query='<?xml version="1.0"?>
        <s:Envelope xmlns:s="http://schemas.xmlsoap.org/soap/envelope/"
        s:encodingStyle="http://schemas.xmlsoap.org/soap/encoding/">
        <s:Body> ' +
        # Dann kommt nochmal der Aufruf, diesmal steht der Funktionsname vorne
        # Der mitgegebene Parameter steht innerhalb des Funktions-Tags
        # Hier ist NewPhonebookID=0 gemeint:
        '<u:GetPhoneBook xmlns:u="urn:dslforum-org:service:X_AVM-DE_OnTel:1">
        <NewPhonebookID>0</NewPhonebookID>
        </u:GetPhoneBook>'+
        # Und das Ende ist auch immer gleich
        '</s:Body>
        </s:Envelope>'

# Query abschicken. Diesmal ist nur der URL zum Service anders:
$r = [xml]$w.UploadString("https://fritz.box:"+$port+"/upnp/control/x_contact",$query)

# In der Antwort steckt nicht das Telefonbuch selbst sondern ein URL zum Download:
$url=$r.Envelope.Body.GetPhonebookResponse.NewPhonebookURL

# Am Besten funktioniert der Download, wenn im WebClient keine Header gesetzt sind.
$w.Headers.Clear()

# Und gleich in die Datei saugen:
$w.DownloadFile( $url, "pbook.xml")