﻿([xml](New-Object System.Net.WebClient).DownloadString("http://fritz.box:49000/tr64desc.xml")).GetElementsByTagName("serviceList") | 
    %{ $_.service}|
    Select-Object serviceType, controlURL, 
        @{Label="XML";Expression={
            '<a href="http://fritz.box:49000' + $_.SCPDURL + '">' + $_.SCPDURL + '</a>'
        }},
        @{Label="Dokument bei AVM";  Expression={
            $pdf= $_.SCPDURL -replace '.xml', '.pdf'
            '<a href="http://avm.de/fileadmin/user_upload/Global/Service/Schnittstellen'+ $pdf + '" target="_blank">'+ $pdf + '</a>'
        }} |
    ConvertTo-Html |
    # Links scharf schalten
    %{ $_ -replace '&lt;', '<'} |
    %{ $_ -replace '&gt;', '>'} |
    %{ $_ -replace '&quot;', '"'} |
    # Inkonsistente Dateinamen korrigieren ;-)
    %{ $_ -replace 'x_upnpSCPD.pdf', 'x_upnp.pdf'} |
    %{ $_ -replace 'x_tamSCPD.pdf', 'x_tam.pdf'} |
    %{ $_ -replace 'ethifconfigSCPD.pdf', 'lanifconfigSCPD.pdf'} |
    Out-File services.html

    Invoke-Item services.html