// Copyright (c) 2014-2015 Oliver Lau <ola@ct.de>, Heise Zeitschriften Verlag
// All rights reserved.

#include "PubSub.h"
#include <list>


typedef std::list<Subscriber*> SubscriberList;


class PublisherPrivate {
public:
  PublisherPrivate() 
    : isBlocked(false)
  { /* ... */ }
  ~PublisherPrivate() {}
  SubscriberList subscribers;
  bool isBlocked;
};


Publisher::Publisher()
  : d(new PublisherPrivate)
{ /* ... */ }


void Publisher::broadcast(const Variant &message, Subscriber *ignoredSubscriber)
{
  if (!d->isBlocked) {
    SubscriberList::iterator s;
    for (s = d->subscribers.begin(); s != d->subscribers.end(); ++s)
      if (*s != ignoredSubscriber)
        (*s)->update(message, this);
  }
}


void Publisher::subscribe(Subscriber *subscriber)
{
  d->subscribers.push_back(subscriber);
}


void Publisher::unsubscribe(Subscriber *subscriber)
{
  d->subscribers.remove(subscriber);
}


void Publisher::block(bool enabled)
{
  d->isBlocked = enabled;
}


bool Publisher::isBlocked(void) const
{
  return d->isBlocked;
}
