// Copyright (c) 2014-2015 Oliver Lau <ola@ct.de>, Heise Zeitschriften Verlag
// All rights reserved.

#include <iostream>
#include <string>
#include "Variant.h"
#include "PubSub.h"

class Bell : public Subscriber {
public:
  Bell(void) { /* ... */ }

  void notify(const Variant &message, Publisher *sender = NULL) {
    if (!message.isInteger())
      return;
    int duration = message.toInt();
    std::cout << duration << " Sekunde" << (duration == 1 ? "" : "n")
      << " klingeln" << std::endl;
  }
};


class Lamp : public Subscriber {
public:
  Lamp() { /* ... */ }

  void notify(const Variant &message, Publisher *sender = NULL) {
    if (!message.isInteger() || message.toInt() <= 1)
      return;
    std::cout << "Alarmleuchte ist an." << std::endl;
  }
};


class BellButton : public Publisher {
public:
  BellButton(void) { /* ... */ }

  void press(void) {
    broadcast(1);
  }

  void pressLong(void) {
    broadcast(5);
  }
};





int main(int argc, char *argv[]) 
{
  BellButton button;
  Bell bell;
  Lamp lamp;

  button.subscribe(&bell);
  button.subscribe(&lamp);

  button.press();
  button.pressLong();

  button.unsubscribe(&bell);
  button.unsubscribe(&lamp);

  return 0;
}
