// Copyright (c) 2014-2015 Oliver Lau <ola@ct.de>, Heise Zeitschriften Verlag
// All rights reserved.

#include "Variant.h"


class VariantPrivate {
public:
  union DataStorage {
    char c;
    unsigned char uc;
    int i;
    unsigned int ui;
    long l;
    unsigned long ul;
    double d;
    float f;
    void *p;
  } data;
  std::string s;
  Variant::Type type;
};



Variant::Variant(void)
  : d(new VariantPrivate)
{
  d->type = V_NONE;
}


Variant::Variant(char x)
  : d(new VariantPrivate)
{
  d->type = V_CHAR;
  d->data.c = x;
}


Variant::Variant(unsigned char x)
  : d(new VariantPrivate)
{
  d->type = V_UCHAR;
  d->data.uc = x;
}


Variant::Variant(int x)
  : d(new VariantPrivate)
{
  d->type = V_INT;
  d->data.i = x;
}


Variant::Variant(unsigned int x)
  : d(new VariantPrivate)
{
  d->type = V_UINT;
  d->data.ui = x;
}


Variant::Variant(long x)
  : d(new VariantPrivate)
{
  d->type = V_LONG;
  d->data.l = x;
}


Variant::Variant(unsigned long x)
  : d(new VariantPrivate)
{
  d->type = V_ULONG;
  d->data.ul = x;
}


Variant::Variant(double x)
  : d(new VariantPrivate)
{
  d->type = V_DOUBLE;
  d->data.d = x;
}


Variant::Variant(float x)
  : d(new VariantPrivate)
{
  d->type = V_FLOAT;
  d->data.f = x;
}


Variant::Variant(char *x)
  : d(new VariantPrivate)
{
  d->type = V_STRING;
  d->s = x;
}


Variant::Variant(void *x)
  : d(new VariantPrivate)
{
  d->type = V_PTR;
  d->data.p = x;
}


Variant::Variant(const std::string &x)
  : d(new VariantPrivate)
{
  d->type = V_STRING;
  d->s = x;
}


Variant::Variant(const Variant &other)
  : d(new VariantPrivate)
{
  d->type = other.d->type;
  switch (d->type) {
  case V_CHAR:
    d->data.c = other.d->data.c;
    break;
  case V_UCHAR:
    d->data.uc = other.d->data.uc;
    break;
  case V_INT:
    d->data.i = other.d->data.i;
    break;
  case V_UINT:
    d->data.ui = other.d->data.ui;
    break;
  case V_LONG:
    d->data.l = other.d->data.l;
    break;
  case V_ULONG:
    d->data.ul = other.d->data.ul;
    break;
  case V_FLOAT:
    d->data.f = other.d->data.f;
    break;
  case V_DOUBLE:
    d->data.d = other.d->data.d;
    break;
  case V_PTR:
    d->data.p = other.d->data.p;
    break;
  case V_STRING:
    d->s = other.d->s;
    break;
  }
}


Variant::Type Variant::type(void) const
{
  return d->type;
}


Variant Variant::operator=(const Variant &x)
{
  return Variant(x);
}


Variant Variant::operator=(char x)
{
  return Variant(x);
}


Variant Variant::operator=(unsigned char x)
{
  return Variant(x);
}


Variant Variant::operator=(int x)
{
  return Variant(x);
}


Variant Variant::operator=(unsigned int x)
{
  return Variant(x);
}


Variant Variant::operator=(long x)
{
  return Variant(x);
}


Variant Variant::operator=(unsigned long x)
{
  return Variant(x);
}


Variant Variant::operator=(double x)
{
  return Variant(x);
}


Variant Variant::operator=(float x)
{
  return Variant(x);
}


Variant Variant::operator=(char *x)
{
  return Variant(x);
}


Variant Variant::operator=(void *x)
{
  return Variant(x);
}


Variant Variant::operator=(const std::string &x)
{
  return Variant(x);
}


bool Variant::isValid(void) const
{
  return d->type != V_NONE;
}


bool Variant::isInteger(void) const
{
  return d->type == V_INT;
}


bool Variant::isUInteger(void) const
{
  return d->type == V_UINT;
}


bool Variant::isChar(void) const
{
  return d->type == V_CHAR;
}


bool Variant::isUChar(void) const
{
  return d->type == V_UCHAR;
}


bool Variant::isLong(void) const
{
  return d->type == V_LONG;
}


bool Variant::isULong(void) const
{
  return d->type == V_ULONG;
}


bool Variant::isFloat(void) const
{
  return d->type == V_FLOAT;
}


bool Variant::isDouble(void) const
{
  return d->type == V_DOUBLE;
}


bool Variant::isPointer(void) const
{
  return d->type == V_PTR;
}


bool Variant::isString(void) const
{
  return d->type == V_STRING;
}


const std::string &Variant::toString(void) const
{
  return d->s;
}


char Variant::toChar(void) const
{
  return d->data.c;
}


unsigned char Variant::toUChar(void) const
{
  return d->data.uc;
}


int Variant::toInt(void) const
{
  return d->data.i;
}


unsigned int Variant::toUInt(void) const
{
  return d->data.ui;
}


long Variant::toLong(void) const
{
  return d->data.l;
}


unsigned long Variant::toULong(void) const
{
  return d->data.ul;
}


float Variant::toFloat(void) const
{
  return d->data.f;
}


double Variant::toDouble(void) const
{
  return d->data.d;
}


void *Variant::toPointer(void) const
{
  return d->data.p;
}
