﻿using System;
using System.Collections.Generic;
using Xamarin.Forms;

namespace ConferenceApp
{	
	public partial class MainPage : ContentPage
	{	
		public MainPage ()
		{
			InitializeComponent ();
		}
        
        protected override void OnAppearing()
        {
            base.OnAppearing();
            var topics = new List<Topic>
			{
				new Topic { Id = 1, Title = "Agenda" },
				new Topic { Id = 2, Title = "Sprecher" },
				new Topic { Id = 3, Title = "Vorträge" }
			};
            this.BindingContext = topics;
        }

		private void OnItemTapped(object sender, ItemTappedEventArgs e)
		{
			ContentPage page = null;
            var topic = e.Item as Topic;
			switch (topic.Id)
			{
				case 1:
					page = new AgendaPage ();
					break;
				case 2:
					page = new SpeakerPage ();
					break;
				case 3:
					page = new SessionPage ();
					break;
			}
			if (page != null)
			{
				this.Navigation.PushAsync (page);
			}
		}
	}
    public class Topic
    {
        public int Id { get; set; }
        public string Title { get; set; }
    }
}

