using System;
using MonoTouch.Foundation;
using MonoTouch.UIKit;
using System.CodeDom.Compiler;
using System.Collections.Generic;

namespace ConfAppiOS
{
	partial class MainViewController : UITableViewController
	{
		public MainViewController (IntPtr handle) : base (handle)
		{
		}

		public override void ViewDidLoad ()
		{
			base.ViewDidLoad ();
			var topics = Repository.Current.Topics;
			this.TableView.Source = new TopicsTableViewSource (topics, this);
		}

		public override void PrepareForSegue (UIStoryboardSegue segue, NSObject sender)
		{
			base.PrepareForSegue (segue, sender);
			var viewController = segue.DestinationViewController;
			switch (segue.Identifier)
			{
				case "agendaSegue":
 					((AgendaViewController)viewController).Agenda = Repository.Current.Agenda;
					break;
				case "speakerSegue":
					((SpeakersViewController)viewController).Speakers = Repository.Current.Speakers;
					break;
				case "sessionSegue":
					((SessionsViewController)viewController).Sessions = Repository.Current.Sessions;
					break;
			}
		}
	}

	public class TopicsTableViewSource : UITableViewSource
	{
		private List<string> _topics;
		private UITableViewController _controller;

		public TopicsTableViewSource (List<string> topics, UITableViewController controller)
		{
			_topics = topics;
			_controller = controller;
		}

		public override UITableViewCell GetCell (UITableView tableView, NSIndexPath indexPath)
		{
			UITableViewCell cell = tableView.DequeueReusableCell ("agendaCell");
			if (cell == null)
				cell = new UITableViewCell ();
			cell.TextLabel.Text = _topics [indexPath.Row];
			return cell;
		}

		public override int RowsInSection (UITableView tableview, int section)
		{
			return _topics.Count;
		}

		public override void RowSelected (UITableView tableView, NSIndexPath indexPath)
		{
			var item = _topics [indexPath.Row];
			var id = "";
			switch (item)
			{
				case "Agenda":
					id = "agendaSegue";
					break;
				case "Sprecher":
					id = "speakerSegue";
					break;
				case "Vortrge":
					id = "sessionSegue";
					break;
			}
			_controller.PerformSegue (id, _controller);
		}
	}
}
