﻿function Get-FileName()
{   
    [System.Reflection.Assembly]::LoadWithPartialName("System.Windows.Forms") | Out-Null

    $OpenFileDialog = New-Object System.Windows.Forms.OpenFileDialog
    $OpenFileDialog.Filter = "PowerShell-Skripte (*.ps1)|*.ps1|Textdateien (*.txt)|*.txt|Alle Dateien (*.*)| *.*"
    $OpenFileDialog.Title = "Datei einfügen"
    $OpenFileDialog.CheckFileExists = $true
    $OpenFileDialog.Multiselect = $false
    $OpenFileDialog.ShowDialog() | Out-Null
    $OpenFileDialog.FileName
}

function Insert-File()
{
    $fileName = Get-FileName
    if($fileName) {
        $content = Get-Content -LiteralPath $fileName
        $editor = $psISE.CurrentFile.Editor
        $startLine = $editor.CaretLine
        $startCol = $editor.CaretColumn
        if($editor.SelectedText.Length -ne 0) {
            $editor.Select($startLine, $startCol, $startLine, $startCol)
        }
        foreach ($line in $content) {
            $editor.InsertText("$line`r`n")
        }
        $endLine = $editor.CaretLine
        $endCol = $editor.CaretColumn
        $editor.Select($startLine, $startCol, $endLine, $endCol)
    }
}

# $psISE.CurrentPowerShellTab.AddOnsMenu.Submenus.Clear()
$psISE.CurrentPowerShellTab.AddOnsMenu.Submenus.`
    Add("Datei ein_fügen...", {Insert-File}, "Alt+I") | Out-Null
