package com.linkesoft.ctlongitude;

import android.app.Activity;
import android.location.Address;
import android.location.Geocoder;
import android.os.AsyncTask;
import android.util.Log;
import android.widget.Toast;

import com.google.android.gms.auth.GoogleAuthUtil;
import com.google.android.gms.auth.UserRecoverableAuthException;
import com.linkesoft.ctlongitude.common.Friend;

import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.HttpClient;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.json.JSONException;
import org.json.JSONObject;

import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

/**
* Created by andreas on 11.10.14.
*/
public class GetFriendsTask extends AsyncTask<Void, Void, Boolean> {
    private MainActivity.GotFriendsListener gotFriendsListener;
    private Activity activity;

    public GetFriendsTask(Activity activity, MainActivity.GotFriendsListener gotFriendsListener)
    {
        this.activity = activity;
        this.gotFriendsListener = gotFriendsListener;

    }
    @Override
    protected Boolean doInBackground(Void... params) {

        String oauthToken;
        try {
            oauthToken = GoogleAuthUtil.getToken(activity, MainActivity.getAccountName(activity),
                    MainActivity.OAUTH_CLIENT_SCOPE);
        } catch (UserRecoverableAuthException e) {
            Log.v(getClass().getSimpleName(), "UserRecoverableAuthException", e);
            activity.startActivityForResult(e.getIntent(), MainActivity.REQUEST_CODE_SIGN_IN);
            return Boolean.TRUE;
        } catch (Exception e) {
            Log.e(getClass().getSimpleName(), "Could not get OAuth token", e);
            return Boolean.TRUE;
        }
        // eigentlicher Request
        // API erwartet UrlEncodedFormEntity
        HttpContext httpContext = new BasicHttpContext();
        HttpParams httpParameters = new BasicHttpParams();
        HttpClient httpClient = new DefaultHttpClient(httpParameters);
        HttpPost httpPost = new HttpPost(MainActivity.FRIENDS_URL);
        List<NameValuePair> nameValuePairs = new ArrayList<NameValuePair>();
        //nameValuePairs.add(new BasicNameValuePair("as_array", "true"));
        nameValuePairs.add(new BasicNameValuePair("avatar", "true"));
        nameValuePairs.add(new BasicNameValuePair("oauth[clientId]", MainActivity.CLIENT_ID));
        nameValuePairs.add(new BasicNameValuePair("oauth[token]", oauthToken));
        try {
            httpPost.setEntity(new UrlEncodedFormEntity(nameValuePairs));
            HttpResponse response = httpClient.execute(httpPost, httpContext);
            HttpEntity entity = response.getEntity();
            String result = EntityUtils.toString(entity);
            // JSON parsen
            JSONObject obj = new JSONObject(result);
            Log.v(getClass().getSimpleName(), "Result JSON: " + obj);
            if (!obj.getString("status").equals("ok")) {
                Log.e(getClass().getSimpleName(), "Error, server returned " + obj.getString("status"));
                return Boolean.TRUE;
            }
            // fill friends array
            final List<Friend> friends = new ArrayList<Friend>();
            // look up addresses with reverse geo-coding
            Geocoder geocoder = new Geocoder(activity);
            Address ownAddress=null;
            JSONObject jsonfriends=obj.getJSONObject("users");
            //for (int i = 0; i < obj.getJSONArray("users").length(); i++) {
            for (Iterator<String> keys = jsonfriends.keys();keys.hasNext();) {
                String key=keys.next();
                //JSONObject friendobj = arr.getJSONObject(i);
                JSONObject friendobj = jsonfriends.getJSONObject(key);
                Friend friend = new Friend();
                try {
                    friend.setFromJSON(friendobj);
                    if (Geocoder.isPresent()) // nicht überall verfügbar
                    {
                        try {
                            List<Address> address = geocoder.getFromLocation(friend.location.getLatitude(),
                                    friend.location.getLongitude(), 1);
                            if (address != null && address.size() != 0)
                                friend.address = address.get(0);

                        } catch (Exception e) {
                            Log.e(getClass().getSimpleName(), "Error getting friend location for "+friend.name, e);
                        }
                    }
                    if (!friend.userid.equals(MainActivity.getAccountUserId(activity)))
                        friends.add(friend);
                    else
                        ownAddress = friend.address;
                    // TODO find address for real current location (our
                    // address on ctLongitude could be outdated)
                } catch (JSONException e) {
                    Log.e(getClass().getSimpleName(), "Invalid JSON Object" + friendobj, e);
                }
            } // for

            // sortiere nach Name, mit Umlaut-Unterstützung über Collator
            final Collator collator = Collator.getInstance();
            collator.setStrength(Collator.PRIMARY);
            Collections.sort(friends, new Comparator<Friend>() {
                @Override
                public int compare(Friend f1, Friend f2) {
                    // locale aware compare
                    return collator.compare(f1.name, f2.name);
                }
            });
            for (Friend friend : friends) {
                Log.v(getClass().getSimpleName(), friend.toString());
            }
            if (gotFriendsListener != null && !isCancelled()) {
                final Address address=ownAddress; // vars must be final
                activity.runOnUiThread(new Runnable() {
                    public void run() {
                        gotFriendsListener.gotFriends(friends,address);
                    }
                });
            }
        } catch (final Exception e) {
            Log.e(getClass().getSimpleName(), "Could not get friends", e);
            activity.runOnUiThread(new Runnable() {
                public void run() {
                    Toast.makeText(activity, e.getLocalizedMessage(), Toast.LENGTH_LONG).show();
                }
            });
        }
        return Boolean.TRUE;
    }
}
