﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading;
using System.Threading.Tasks;
using System.Windows.Forms;
using Microsoft.Kinect;
using NAudio.Midi;

namespace KinectHandTest
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();
        }

        private KinectSensor kinectSensor = null;
        private BodyFrameReader bodyFrameReader = null;
        private Body[] bodies = null;
        private MidiOut midiOut = null;
        private Boolean playing = false;

        private void Form1_Load(object sender, EventArgs e)
        {
            kinectSensor = KinectSensor.GetDefault();
            kinectSensor.Open();
            bodyFrameReader = kinectSensor.BodyFrameSource.OpenReader();
            if (bodyFrameReader != null)
            {
                bodyFrameReader.FrameArrived += this.Reader_FrameArrived;
            }
            midiOut = new MidiOut(0);
            midiOut.Send(MidiMessage.ChangePatch(4, 1).RawData);
        }

        private void Reader_FrameArrived(object sender, BodyFrameArrivedEventArgs e)
        {
            bool dataReceived = false;
            int count = 0;
            using (BodyFrame bodyFrame = e.FrameReference.AcquireFrame())
            {
                if (bodyFrame != null)
                {
                    if (bodies == null)
                    {
                        bodies = new Body[bodyFrame.BodyCount];
                    }
                    bodyFrame.GetAndRefreshBodyData(bodies);
                    dataReceived = true;
                }
            }

            if (dataReceived)
            {
                foreach (Body body in bodies)
                {
                    if (body.IsTracked)
                    {
                        Joint joint = body.Joints[JointType.HandTipRight];
                        if (joint.TrackingState == TrackingState.Tracked)
                        {
                            int x = Convert.ToInt32((joint.Position.X * 100 + 200) / 3.3);
                            int y = Convert.ToInt32(joint.Position.Y * 100 + 100);
                            label1.Text = x.ToString();
                            label2.Text = y.ToString();
                            byte[] byteBuf = { 0, 0, 0 };
                            if (x > 127) x = 127;
                            if (x < 0) x = 0;
                            if ((y < 90) && (!playing))
                            {
                                midiOut.Send(MidiMessage.StartNote(x, 127, 2).RawData);
                                playing = true;
                            }
                            if ((y > 90) && playing)
                            {
                                midiOut.Reset();
                                playing = false;
                            }
                        }
                        else
                        {
                            label1.Text = "Nicht erkannt!";
                            midiOut.Reset();
                            playing = false;
                        }
                        break;
                    }
                }
            }
        }

        private void Form1_FormClosing(object sender, FormClosingEventArgs e)
        {
            if (bodyFrameReader != null)
            {
                // BodyFrameReader is IDisposable
                bodyFrameReader.Dispose();
                bodyFrameReader = null;
            }

            if (kinectSensor != null)
            {
                kinectSensor.Close();
                kinectSensor = null;
            }
            if (serialPort1.IsOpen) serialPort1.Close();
            midiOut.Close();
            midiOut.Dispose();

        }

        private void button1_Click(object sender, EventArgs e)
        {

        }
    }
}
