﻿/**
 *  Copyright (c) 2014 Oliver Lau, Heise Zeitschriften Verlag
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program. If not, see <http://www.gnu.org/licenses/>.
 *
 */

(function ($, window) {
  "use strict";

  function makeArrows() {
    var container = $('#arrows'),
      DURATION = 1, N = 10,
       i, css = '<style type="text/css">';
    for (i = 0; i < N; ++i) {
      container.append('<div class="arrow-right phase-' + i + '"></div>');
      css += '.phase-' + i + ' {\n' +
        ['', '-webkit-', '-moz-', '-ms-'].map(function (prefix) {
          return '  ' + prefix + 'animation-direction: alternate;\n' +
            '  ' + prefix + 'animation-name: phase-opacity;\n' +
            '  ' + prefix + 'animation-duration: ' + (DURATION / 2) + 's;\n' +
            '  ' + prefix + 'animation-timing-function: steps(1, end);\n' +
            '  ' + prefix + 'animation-iteration-count: infinite;\n' +
            '  ' + prefix + 'animation-delay: ' + (i * DURATION / N) + 's;\n';
        }).join('\n') +
      '}\n';
    }
    css += ['', '-webkit-', '-moz-', '-ms-'].map(function (prefix) {
      return '@' + prefix + 'keyframes phase-opacity {\n' +
      '  0% {\n' +
      '      border-color: transparent transparent transparent #b6ff00;\n' +
      '  }\n' +
      '  ' + ((100 - 100 / N * 2) >> 0) + '% {\n' +
      '      border-color: transparent transparent transparent #ff6a00;\n' +
      '  }\n' +
      '}\n';
    }).join('\n');
    css += '</style>';
    $('head').append(css);
  }


  function init() {
    makeArrows();
  }

  $(document).ready(init);
})($, window);
