package com.linkesoft.ctlongitude;

import java.util.*;

import android.app.Activity;
import android.content.*;
import android.content.IntentSender.SendIntentException;
import android.location.Address;
import android.net.Uri;
import android.os.Bundle;
import android.preference.PreferenceManager;
import android.util.Log;
import android.view.*;
import android.view.View.OnClickListener;
import android.widget.Toast;

import com.google.android.gms.common.*;
import com.google.android.gms.common.api.*;
import com.google.android.gms.common.api.GoogleApiClient.ConnectionCallbacks;
import com.google.android.gms.common.api.GoogleApiClient.OnConnectionFailedListener;
import com.google.android.gms.maps.*;
import com.google.android.gms.maps.model.*;
import com.google.android.gms.plus.*;
import com.google.android.gms.plus.PlusClient.OnAccessRevokedListener;
import com.google.android.gms.plus.model.people.Person;
import com.linkesoft.ctlongitude.Friend.GetFriendsTask;
import com.linkesoft.ctlongitude.Friend.GotFriendsListener;

public class MainActivity extends Activity implements ConnectionCallbacks, OnConnectionFailedListener,GotFriendsListener, OnAccessRevokedListener {

	static final String CLIENT_ID = "794079768346.apps.googleusercontent.com";
	static final String OAUTH_CLIENT_SCOPE = "audience:server:client_id:" + CLIENT_ID;
	static final String WEB_URL = "http://<server>/";
	static final String FRIENDS_URL = WEB_URL + "ajax/friends.php";
	static final String POSITION_URL = WEB_URL + "ajax/setloc.php";

	protected static final int REQUEST_CODE_SIGN_IN = 0;

	private static final int FRIENDS_MENU_ID = Menu.FIRST;
	private static final String USERID = "userId";
	private static final String ACCOUNTNAME = "accountName";
	private static final String SENDLOCATIONUPDATES = "sendLocationUpdates";
	private GoogleApiClient googleApiClient;
	private ConnectionResult connectionResult;
	private GoogleMap map;
	private Address currentAddress;

	private final List<Friend> friends = new ArrayList<Friend>();

	@Override
	protected void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.activity_main);

		googleApiClient = new GoogleApiClient.Builder(this, this, this).addApi(Plus.API).addScope(Plus.SCOPE_PLUS_LOGIN).build();

		map = ((MapFragment) getFragmentManager().findFragmentById(R.id.map)).getMap();
		map.setMyLocationEnabled(true); // zeige eigenen Ort

		findViewById(R.id.sign_in_button).setOnClickListener(new OnClickListener() {

			@Override
			public void onClick(View v) {
				if (!googleApiClient.isConnected() && connectionResult != null)
					try {
						connectionResult.startResolutionForResult(MainActivity.this, REQUEST_CODE_SIGN_IN);
					} catch (SendIntentException e) {
						Log.e(getClass().getSimpleName(), "Connection resolution interrupted", e);
				}
			}
		});

	}

	@Override
	protected void onStart() {
		super.onStart();
		if (GooglePlayServicesUtil.isGooglePlayServicesAvailable(this) != ConnectionResult.SUCCESS)
			Toast.makeText(this, "This app requires an Android device with Google Play services", Toast.LENGTH_LONG)
					.show();
		else
			googleApiClient.connect(); // asynchron, ruft entweder onConnected oder onConnectionFailed
	}

	@Override
	protected void onStop() {
		super.onStop();
		googleApiClient.disconnect(); // asynchron
	}

	@Override
	public boolean onCreateOptionsMenu(Menu menu) {
		getMenuInflater().inflate(R.menu.main, menu);
		return true;
	}

	@Override
	public boolean onPrepareOptionsMenu(Menu menu) {
		fillFriendsMenu(menu.findItem(R.id.friendsSubMenu).getSubMenu());
		menu.findItem(R.id.sendLocationUpdates).setChecked(getSendLocationUpdates(this));
		return super.onPrepareOptionsMenu(menu);
	}
	
	@Override
	public boolean onOptionsItemSelected(MenuItem item) {
		switch (item.getItemId()) {
		case R.id.refresh:
			getFriends();
			return true;
		case R.id.openInWeb:
			openBrowser();
			return true;
		case R.id.disconnect:
			signOut();
			return true;
		case R.id.sendLocationUpdates:
			toggleLocationUpdates();
			return true;
		}

		// kein Standard-Men-Eintrag
		if (item.getItemId() >= FRIENDS_MENU_ID && item.getItemId() - FRIENDS_MENU_ID < friends.size()) {
			Friend friend = friends.get(item.getItemId() - FRIENDS_MENU_ID);
			// center on map
			centerMapOnFriend(friend);
			showMarkerInfoForFriend(friend);
			return true;
		}
		return super.onOptionsItemSelected(item);
	}

	private void fillFriendsMenu(SubMenu subMenu) {
		int ind = 0;
		subMenu.clear();
		for (Friend friend : friends) {
			subMenu.add(Menu.NONE, FRIENDS_MENU_ID + ind, Menu.NONE, friend.name);
			ind++;
		}

	}
	// Ausloggen
	private void signOut() {
		if(googleApiClient.isConnected()) {
			Plus.AccountApi.clearDefaultAccount(googleApiClient);
			Plus.AccountApi.revokeAccessAndDisconnect(googleApiClient).setResultCallback(new ResultCallback<Status>() {
				@Override
				public void onResult(Status result) {
					findViewById(R.id.sign_in_button).setVisibility(View.VISIBLE);
					Toast.makeText(MainActivity.this, "Logged out", Toast.LENGTH_SHORT).show();
					// beende Activity
					finish();
				}
			});
		}
	}
	private void centerMapOnFriend(Friend friend) {
		CameraPosition center = new CameraPosition.Builder().target(friend.position).zoom(15).build();
		map.animateCamera(CameraUpdateFactory.newCameraPosition(center));		
	}

	private void showAllFriendsOnMap() {
		if(friends.size()==0)
		{
			Log.v(getClass().getSimpleName(),"no friends to show");
			return;
		}
		LatLngBounds.Builder builder = new LatLngBounds.Builder();
		for (Friend friend : friends) {
			builder.include(friend.position);
		}
		LatLngBounds bounds = builder.build();
		int border = (int) (40 * getResources().getDisplayMetrics().density);
		// add some space so pins can be shown
		map.animateCamera(CameraUpdateFactory.newLatLngBounds(bounds, border)); 	
		}

	

	private void toggleLocationUpdates() {
		SharedPreferences prefs = PreferenceManager.getDefaultSharedPreferences(this);
		SharedPreferences.Editor prefsEditor = prefs.edit();
		boolean sendUpdates=!getSendLocationUpdates(this);
		prefsEditor.putBoolean(SENDLOCATIONUPDATES, sendUpdates);
		prefsEditor.commit();
		if(sendUpdates)
			LocationReceiver.startPositionUpdates(this);
		else
			LocationReceiver.stopPositionUpdates(this);
	}



	private void showMarkerInfoForFriend(Friend friend) {
		if (friend.marker != null)
			friend.marker.showInfoWindow();
	}

	private void openBrowser() {
		startActivity(new Intent(Intent.ACTION_VIEW, Uri.parse(WEB_URL)));
	}
	// Callback-Methoden

	@Override
	public void onConnected(Bundle connectionHint) {
		Log.v(getClass().getSimpleName(), "onConnected");
		// Log-In-Button ausblenden
		findViewById(R.id.sign_in_button).setVisibility(View.GONE);
		String accountName=Plus.AccountApi.getAccountName(googleApiClient);
		Toast.makeText(this, accountName + " is connected.", Toast.LENGTH_LONG).show();
		// store accountName and id for later use
		SharedPreferences prefs = PreferenceManager.getDefaultSharedPreferences(this);
		SharedPreferences.Editor prefsEditor = prefs.edit();
		prefsEditor.putString(ACCOUNTNAME, accountName);
		Person user = Plus.PeopleApi.getCurrentPerson(googleApiClient);
		prefsEditor.putString(USERID, user.getId());
		prefsEditor.commit();
		
		getFriends();
		if(getSendLocationUpdates(this))
			LocationReceiver.startPositionUpdates(this);
	}

	@Override
	public void onConnectionSuspended(int cause) {
		Log.v(getClass().getSimpleName(), "onConnectionSuspended");
	}

	@Override
	public void onConnectionFailed(ConnectionResult result) {
		Log.v(getClass().getSimpleName(), "onConnectionFailed " + result);
		// speichere ConnectionResult für spätere Verwendung
		connectionResult = result;
		findViewById(R.id.sign_in_button).setVisibility(View.VISIBLE);
	}
	

	@Override
	protected void onActivityResult(int requestCode, int responseCode, Intent intent) {
	
		if (requestCode == REQUEST_CODE_SIGN_IN && responseCode == RESULT_OK) {
			googleApiClient.connect(); // starte OAuth-Authentifizierung, asynchron
		} else
			super.onActivityResult(requestCode, responseCode, intent);
	}

	@Override
	public void onAccessRevoked(ConnectionResult arg0) {
		Log.v(getClass().getSimpleName(),"access revoked, logged out");
		Toast.makeText(this, getAccountName(this)+ " logged out.", Toast.LENGTH_LONG).show();
		findViewById(R.id.sign_in_button).setVisibility(View.VISIBLE);		
	}


	private void getFriends() {
		GetFriendsTask friendsTask = new GetFriendsTask(this,this);
		friendsTask.execute();
	}
	@Override
	public void gotFriends(List<Friend> gotfriends,Address ownAddress) {
		currentAddress=ownAddress;
		friends.clear();
		friends.addAll(gotfriends);
		invalidateOptionsMenu();
		// put pins on map
		map.clear();
		for (Friend friend : friends) {
			MarkerOptions marker = new MarkerOptions();
			marker.position(friend.position);
			marker.title(friend.name + " (" + friend.getFormattedDate() + ")");
			if(friend.address!=null)
				marker.snippet(friend.getFormattedAddress(currentAddress)); // Untertitel
			friend.marker = map.addMarker(marker); // speichere Marker, um ihn spter anzeigen zu knnen
		}
		showAllFriendsOnMap();
	}
	
	public static String getAccountUserId(Context ctx)
	{
		SharedPreferences prefs = PreferenceManager.getDefaultSharedPreferences(ctx);
		return prefs.getString(USERID, "");
	}
	public static String getAccountName(Context ctx)
	{
		SharedPreferences prefs = PreferenceManager.getDefaultSharedPreferences(ctx);
		return prefs.getString(ACCOUNTNAME, "");		
	}

	public static boolean getSendLocationUpdates(Context ctx)
	{
		SharedPreferences prefs = PreferenceManager.getDefaultSharedPreferences(ctx);
		return prefs.getBoolean(SENDLOCATIONUPDATES, true);		
	}


	

	
}
