# EventWatch.ps1 (c) c't/Peter Siering, GPLv3
# Fragt Ereignisprotokoll auf Fehler und kritische
# Ereignisse ab und schickt E-Mail, wenn diese nicht
# auf einer schwarzen Liste stehen.
# Weitere Hinweise in c't 10/2012, S. 148 (Version 1)
# und c't 13/14, S. ??? (Version 1.1)

# Aenderungen 1.1:
# - Pruefhilfe fuer mail-Konfiguration
# - andere Technik zum Versenden von Mail
#   - braucht Powershell 4/.NET 4.5
#   - ssl standardmaessig aktiviert
# - Lauffaehigkeit unter Windows 8.1
#   - Dank an Horst Schmid
# - Installer

# Aufrufpfad bestimmen, dort Variablen einlesen 
$myhome= Split-Path $MyInvocation.MyCommand.Path
try { . "$myhome/EventWatch_vars.ps1" }
catch {
    Write-Error -ErrorRecord $_
    exit 1
}

# Mehrfach benoetigte Funktionen
function MySendMail( $subj, $body) 
{
	$error.Clear()
	if (( $smtppass) -And ( $smtpuser)) {
		$secpass= ConvertTo-SecureString $smtppass -AsPlainText -Force
		$mycreds= New-Object System.Management.Automation.PSCredential( $smtpuser, $secpass)
	}
	try { if ( $mycreds) {
			send-mailmessage -to $to -from $from -subject $subj -body $body -EA SilentlyContinue `
				-smtpserver $smtpserver -usessl -port $smtpport -credential $mycreds
		} else {
			send-mailmessage -to $to -from $from -subject $subj -body $body `
				-smtpserver $smtpserver -usessl -port $smtpport -EA SilentlyContinue
		}
		If ( $error.Count -gt 0) {
			$error[0].ToString()
			exit 1
		}
	}		
	catch { 
		$error[0].ToString() 
		exit 1
	}
}

if ( !$hostname) {
	$hostname= $env:computername
}

# Fuer einfaches Pruefen der Mail-Konfiguration 
if ( $args[0] -eq "-mailcheck") {
	MySendMail "[eventwatch] $hostname Mail-Test" "Die Mail-Konfiguration funktioniert."
	exit 0
}

# Ausnahmeliste holen, wenn URL, sonst lokal
if ( $blacklisturl -ne "") {
    try { 
        $wget= New-Object System.Net.Webclient
        $wget.DownLoadFile($blacklisturl,"$myhome/blacklist.xml") 
    }
    catch { Write-Warning "Error fetching blacklist" }
}
try { $blacklist= import-clixml "$myhome/blacklist.xml" }
catch { $blacklist= @() }

# Zeitpunkt merken
$startdate= Get-Date

# Zeitpunkt des letzten Laufes, sonst vergangene 12 Stunden
try { $lasttimestamp= Import-Clixml $env:temp\event_watch.xml }
catch { $lasttimestamp= $startdate-(New-TimeSpan -hour 12) }

# Kritische Ereignisse (1) und Fehler (2) abfragen
$eventcount=0
$msgs=@()
$lognames = Get-WinEvent -ListLog *
foreach ( $level in @(1, 2)) {
    foreach ($logname in $lognames) {
		# Ereignisprotokoll(e) auslesen
		$events= Get-WinEvent -FilterHashTable @{ 
				LogName = $logname.LogName; level = $level; Starttime=$lasttimestamp } `
				-MaxEvents 30
		$eventcount+= ($events | Measure-Object).Count
    
		# Weiterverarbeitung nur, wenn Nachrichten vorliegen
		if ( ($events | Measure-Object).Count -gt 0 ) {
			foreach ( $event in $events) {
				$msg=$event.Message
				$logname=$event.LogName
				if ( $logname) { $logname=$logname -ireplace( "Microsoft-Windows-", "") }
				$provname=$event.ProviderName
				if ( $provname) { $provname=$provname -ireplace( "Microsoft-Windows-", "") }
				if ( $logname.Contains( $provname)) { $logname="" }
				if (( $provname -eq $logname) -or ( $logname -eq "")) { 
					$msg= ( $provname+ " - "+ $msg + " ("+ $event.Id+ ")")
				} else {
					$msg= ( $logname + "/"+ $provname+ " - "+ $msg + " ("+ $event.Id+ ")")
				}
            
				# Gegen Blacklist pruefen
				foreach ( $line in $blacklist) {
					if ( $msg -like $line) {
						$msg=""
						$eventcount--
						break
					}
				}
				if ( $msg -ne "") { $msgs+= $msg }
			}
		} else { $msg="" }
	}
}

# nur etwas ausgeben, wenn Ereignisse vorliegen
if ( $eventcount -eq 0) { 
    # Datum der Abfrage merken 
    $startdate | export-clixml $env:temp\event_watch.xml
    exit 0
}

# Nachrichtentext zusammenstellen
$OFS="`r`n`r`n"
$msgstxt=[string]($msgs)
$msgstxt="Kritische Ereignisse oder Fehler auf "+ $hostname +":`n`n"+ $msgstxt

# Ohne Mailserver ausgeben und Abflug
if ( $smtpserver -eq "mailhorst.example.com") {
    $msgstxt
    exit 0
}

# Mail schicken
$subject="[eventwatch] $hostname"
MySendMail $subject $msgstxt

# Erst jetzt Datum der letzten Abfrage wegschreiben
$startdate | export-clixml $env:temp\event_watch.xml
exit 0


