#define RUNPROC matrixmulDGEMM(ap, bp, cp, dim, dim0) 

void matrixmulDGEMM(double *a, double *b, double *c, int dim, int dim0) {

	cblas_dgemm( //C=alpha*A*B+beta
		CblasRowMajor, //Layout row-column
		CblasNoTrans,  // a not trans
		CblasNoTrans, //  b not trans 
		dim,   // M
		dim,   // N
		dim,   // K
		1.0,   //alpha
		a,    // pointer to a 
		dim0,  // leading Dim i.e  &a[1][0]-&a[0][0]=DIM0*8
		b,
		dim0,
		0.0, //beta
		c,
		dim0
		);
}