package com.linkesoft.oauthdemo;

import android.app.Activity;
import android.content.*;
import android.content.IntentSender.SendIntentException;
import android.os.Bundle;
import android.util.Log;
import android.view.*;
import android.view.View.OnClickListener;
import android.webkit.WebView;
import android.widget.Toast;

import com.google.android.gms.common.*;
import com.google.android.gms.common.api.*;
import com.google.android.gms.common.api.GoogleApiClient.ConnectionCallbacks;
import com.google.android.gms.common.api.GoogleApiClient.OnConnectionFailedListener;
import com.google.android.gms.plus.Plus;
import com.google.android.gms.plus.model.people.Person;

/**
 * Einfaches Beispielprojekt zur Anmeldung mit Google+ Client 
 * 
 * @author Andreas Linke
 *
 */
public class MainActivity extends Activity implements ConnectionCallbacks, OnConnectionFailedListener {

	protected static final int REQUEST_CODE_SIGN_IN = 0;
	private GoogleApiClient googleApiClient;
	private ConnectionResult connectionResult;

	@Override
	protected void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.activity_main);
		// Plus-Client erzeugen, connect erfolgt später
		googleApiClient = new GoogleApiClient.Builder(this, this, this)
			.addApi(Plus.API, null)
			.addScope(Plus.SCOPE_PLUS_PROFILE).build();
		// Google-Login-Button
		findViewById(R.id.sign_in_button).setOnClickListener(new OnClickListener() {
			@Override
			public void onClick(View v) {
				if (!googleApiClient.isConnected() && connectionResult != null)
					try {
						connectionResult.startResolutionForResult(MainActivity.this, REQUEST_CODE_SIGN_IN);
					} catch (SendIntentException e) {
						Log.e(getClass().getSimpleName(), "Connection resolution interrupted", e);
					}
			}
		});

	}

	// wird nach Rückkehr vom Google-Zustimmungsdialog aufgerufen
	@Override
	protected void onActivityResult(int requestCode, int resultCode, Intent data) {
		Log.v(getClass().getSimpleName(), "onActivityResult " + resultCode);
		if (requestCode == REQUEST_CODE_SIGN_IN && resultCode == RESULT_OK) {
			googleApiClient.connect(); // starte OAuth-Authentifizierung, asynchron
		} else
			super.onActivityResult(requestCode, resultCode, data);
	}

	@Override
	protected void onStart() {
		super.onStart();
		if (GooglePlayServicesUtil.isGooglePlayServicesAvailable(this) != ConnectionResult.SUCCESS)
			Toast.makeText(this, "This app requires an Android device with Google Play services", Toast.LENGTH_LONG)
					.show();
		else
			googleApiClient.connect(); // asynchron, ruft entweder onConnected oder onConnectionFailed
	}

	@Override
	protected void onStop() {
		super.onStop();
		googleApiClient.disconnect(); // asynchron
	}

	@Override
	public boolean onCreateOptionsMenu(Menu menu) {
		getMenuInflater().inflate(R.menu.main_menu, menu);
		return true;
	}

	@Override
	public boolean onOptionsItemSelected(MenuItem item) {
		switch (item.getItemId()) {
		case R.id.sign_out:
			signOut();
			return true;
		}
		return super.onOptionsItemSelected(item);
	}

	// Ausloggen
	private void signOut() {
		if(googleApiClient.isConnected()) {
			Plus.AccountApi.clearDefaultAccount(googleApiClient);
			Plus.AccountApi.revokeAccessAndDisconnect(googleApiClient).setResultCallback(new ResultCallback<Status>() {
				@Override
				public void onResult(Status result) {
					findViewById(R.id.sign_in_button).setVisibility(View.VISIBLE);
					Toast.makeText(MainActivity.this, "Logged out", Toast.LENGTH_SHORT).show();
					// beende Activity
					finish();
				}
			});
		}
	}
	
	// zeige Benutzer-Infos
	private void showUserInfo() {
		String accountName=Plus.AccountApi.getAccountName(googleApiClient);
		Log.v(getClass().getSimpleName(),"User account: "+accountName);

		Person user = Plus.PeopleApi.getCurrentPerson(googleApiClient);
		String name;
		if(user.hasNickname())
			name=user.getNickname();
		else
			name = user.getDisplayName();
		
		// lade Bild des Benutzers in einem WebView
		String imageURL = user.getImage().getUrl(); // URL des Google+ Profilbildes
		String htmlData = "<center>Hello " + name + "<br><img src=\"" + imageURL + "\"></center>";
		WebView webView = new WebView(this);
		webView.loadDataWithBaseURL(null, htmlData, null, "UTF-8", null);
		// Toast mit custom view
		Toast toast = new Toast(this);
		toast.setView(webView);
		toast.setDuration(Toast.LENGTH_LONG);
		toast.show();
	}
	
	// Callback-Methoden

	@Override
	public void onConnected(Bundle connectionHint) {
		Log.v(getClass().getSimpleName(), "onConnected");
		// Log-In-Button ausblenden
		findViewById(R.id.sign_in_button).setVisibility(View.GONE);
		showUserInfo();
	}

	@Override
	public void onConnectionSuspended(int cause) {
		Log.v(getClass().getSimpleName(), "onConnectionSuspended");
	}

	@Override
	public void onConnectionFailed(ConnectionResult result) {
		Log.v(getClass().getSimpleName(), "onConnectionFailed " + result);
		// speichere ConnectionResult für spätere Verwendung
		connectionResult = result;
		findViewById(R.id.sign_in_button).setVisibility(View.VISIBLE);
	}

}
