// Generated by CoffeeScript 1.7.1
(function() {
  var Picture, pic, pictureDir, pictureSuffix, pictures, urlPrefix, _i, _len, _ref;

  pictureDir = 'pixel/';

  pictureSuffix = '.jpg';

  urlPrefix = 'http://www.heise.de/artikel-archiv/ct/';

  pictures = [
    {
      id: 201319172,
      name: 'Telefonbau'
    }, {
      id: 201320132,
      name: 'Browser-Feuerwerk'
    }, {
      id: 201321108,
      name: 'Soziales privatisieren'
    }, {
      id: 201326182,
      name: 'HTML maßgeschneidert'
    }, {
      id: 201326186,
      name: 'Rock\'n\'Scroll'
    }
  ];

  Picture = (function() {
    Picture.prototype.regex = /(^\d{4})(\d{2})0*(\d{1,3}$)/;

    Picture.prototype.counterAdd = function() {
      return Picture.counter++;
    };

    function Picture(params) {
      var match;
      this.name = params.name, this.id = params.id;
      this.num = this.counterAdd;
      this.pic = "" + pictureDir + this.id + pictureSuffix;
      match = ("" + this.id).match(this.regex);
      if (match == null) {
        match = (function() {
          var _i, _results;
          _results = [];
          for (_i = 0; _i <= 3; _i++) {
            _results.push('unbekannt');
          }
          return _results;
        })();
      }
      this.issue = "c't " + match[2] + "/" + match[1] + ", Seite " + match[3];
      this.url = urlPrefix + match.slice(1, 4).join('/');
    }

    return Picture;

  })();

  window.cs = {
    pictures: [],
    gallery: function(picNum) {
      var container, next, prev;
      if (picNum == null) {
        picNum = 0;
      }
      container = document.getElementById('gallery');
      prev = picNum < 1 ? this.pictures.length - 1 : picNum - 1;
      next = picNum + 1 >= this.pictures.length ? 0 : picNum + 1;
      return container.innerHTML = "<figcaption>\n	<h3>Bild " + (picNum + 1) + " von " + this.pictures.length + ":</h3>\n	<h2>" + this.pictures[picNum].name + "</h2>\n	<small>erschienen in: <a href='" + this.pictures[picNum].url + "'>" + this.pictures[picNum].issue + "</a></small>\n</figcaption>\n<div>\n	<span onclick='window.cs.gallery(" + prev + ")' title='Bild " + (prev + 1) + "'>Zurück</span>\n	<img src='" + this.pictures[picNum].pic + "' alt=\"" + this.pictures[picNum].name + "\"/>\n	<span onclick='window.cs.gallery(" + next + ")' title='Bild " + (next + 1) + "'>Weiter</span>\n</div>";
    }
  };

  for (_i = 0, _len = pictures.length; _i < _len; _i++) {
    pic = pictures[_i];
    window.cs.pictures.push(new Picture({
      name: pic.name,
      id: pic.id
    }));
  }

  if ((_ref = window.cs) != null) {
    _ref.gallery(0);
  }

}).call(this);

//# sourceMappingURL=galerie.map
