#!/usr/bin/python2
# Checks for infections of Linux/Flasher.A router malware
# by checking for the dsniff process that runs on infected
# hosts.
# Released under WTFPL - www.wtfpl.net
# Darren Martyn (2013) - www.insecurety.net
""" Test run of it to see does it work...

# with simulated infection by running dsniff on host
[infodox@malware dev]$ python test.py test testpass 78.47.xxx.xxx
(+) Not a windows! WMI will be not imported
(+) Using 78.47.248.142 as router IP
(+) Connecting via SSH to 78.47.248.142
(+) Logged in... Checking for dsniff process
(!) ROUTER APPEARS TO BE INFECTED!

# after killing dsniff process to simulate uninfected host
[infodox@malware dev]$ python test.py test testpass 78.47.xxx.xxx
(+) Not a windows! WMI will be not imported
(+) Using 78.47.248.142 as router IP
(+) Connecting via SSH to 78.47.248.142
(+) Logged in... Checking for dsniff process
(*) Router seems clean!

"""

import sys
import time
try:
    import paramiko
except ImportError:
    sys.exit("(-) You need the Paramiko python module to run this script. pip install paramiko")
import socket
import struct
import os
try:
    import wmi
except ImportError:
    print "(+) Not a windows! WMI will be not imported"
    pass
    
cyan = "\x1b[1;36m"
red = "\x1b[1;31m"
clear = "\x1b[0m"

def flash(color,text,times):
	sys.stdout.write(text)
	line1 = "\x0d\x1b[2K%s%s" % (color,text)
	line2 = "\x0d\x1b[2K%s%s" % (clear,text)
	for x in range(0,times):
		sys.stdout.write(line1)
		sys.stdout.flush()
		time.sleep(.2)
		sys.stdout.write(line2)
		sys.stdout.flush()
		time.sleep(.2)
	print line2


def get_default_gateway_linux():
    """Read the default gateway directly from /proc."""
    with open("/proc/net/route") as fh:
        for line in fh:
            fields = line.strip().split()
            if fields[1] != '00000000' or not int(fields[3], 16) & 2:
	        continue
            return socket.inet_ntoa(struct.pack("<L", int(fields[2], 16)))
	    
def get_default_gateway_windows():
    """ Use WMI to get the default gateway """
    wmi_obj = wmi.WMI()
    wmi_sql = "select IPAddress,DefaultIPGateway from Win32_NetworkAdapterConfiguration where IPEnabled=TRUE"
    wmi_out = wmi_obj.query( wmi_sql )
    for dev in wmi_out:
         gateway = dev.DefaultIPGateway[0]
	 return gateway
	 
def checkInfection(ip, user, passwd):
    """ Get the process list and if "dsniff" is present, assume infected and say its so """
    ssh = paramiko.SSHClient()
    ssh.set_missing_host_key_policy(paramiko.AutoAddPolicy())
    try:
        print "(+) Connecting via SSH to %s" %(ip)
        ssh.connect(ip, username=user, password=passwd)
    except paramiko.AuthenticationException:
	sys.exit("(-) Password or username incorrect!")
    except Exception:
        sys.exit("(-) Connection Failed perhaps?")
    print "(+) Logged in... Checking for dsniff process"
    stdin, stdout, stderr = ssh.exec_command('ps aux')
    proclist = stdout.read()
    if "dsniff" in proclist:
        flash(red,"(!) ROUTER APPEARS TO BE INFECTED!",3)
    else:
        flash(cyan,"(*) Router seems clean!",3)
    
def main(args):
    if len(args) == 3: # if the user doesnt know the IP we try get it
        if os.name == "nt":
            gateway = get_default_gateway_windows()
        elif os.name == "posix":
            gateway = get_default_gateway_linux()
    elif len(args) == 4:  # we now use user specified IP
        gateway =  sys.argv[3]
    print "(+) Using %s as router IP" %(gateway)
    checkInfection(ip=gateway, user=sys.argv[1], passwd=sys.argv[2])
    
if __name__ == "__main__":
    if len(sys.argv) < 3:
        sys.exit("usage: %s username password [ip]" %(sys.argv[0]))
    main(sys.argv)
# "Java applications consist of .class files. These files do not represent the socio-economic status of the code."
# EOF