/*
 * Decompiled with CFR 0.152.
 */
import java.util.concurrent.atomic.AtomicInteger;

public final class mandelbrot {
    static byte[][] out;
    static AtomicInteger yCt;
    static double[] Crb;
    static double[] Cib;

    static int getByte(int n, int n2) {
        int n3 = 0;
        for (int i = 0; i < 8; i += 2) {
            double d = Crb[n + i];
            double d2 = Cib[n2];
            double d3 = Crb[n + i + 1];
            double d4 = Cib[n2];
            int n4 = 0;
            int n5 = 49;
            do {
                double d5 = d * d - d2 * d2 + Crb[n + i];
                double d6 = d * d2 + d * d2 + Cib[n2];
                d = d5;
                d2 = d6;
                double d7 = d3 * d3 - d4 * d4 + Crb[n + i + 1];
                double d8 = d3 * d4 + d3 * d4 + Cib[n2];
                d3 = d7;
                d4 = d8;
            } while (!(d * d + d2 * d2 > 4.0 && (n4 |= 2) == 3 || d3 * d3 + d4 * d4 > 4.0 && (n4 |= 1) == 3) && --n5 > 0);
            n3 = (n3 << 2) + n4;
        }
        return ~n3;
    }

    static void putLine(int n, byte[] byArray) {
        for (int i = 0; i < byArray.length; ++i) {
            byArray[i] = (byte)mandelbrot.getByte(i * 8, n);
        }
    }

    public static void warmUp(String[] stringArray) throws Exception {
        for (int i = 0; i < 100; ++i) {
            mandelbrot.benchmark(stringArray);
        }
    }

    public static void benchmark(String[] stringArray) throws Exception {
        int n = 8000;
        if (stringArray.length >= 1) {
            n = Integer.parseInt(stringArray[0]);
        }
        Crb = new double[n + 7];
        Cib = new double[n + 7];
        double d = 2.0 / (double)n;
        for (int i = 0; i < n; ++i) {
            mandelbrot.Cib[i] = (double)i * d - 1.0;
            mandelbrot.Crb[i] = (double)i * d - 1.5;
        }
        yCt = new AtomicInteger();
        out = new byte[n][(n + 7) / 8];
        Thread[] threadArray = new Thread[2 * Runtime.getRuntime().availableProcessors()];
        for (int i = 0; i < threadArray.length; ++i) {
            threadArray[i] = new Thread(){

                @Override
                public void run() {
                    int n;
                    while ((n = yCt.getAndIncrement()) < out.length) {
                        mandelbrot.putLine(n, out[n]);
                    }
                }
            };
        }
        for (Thread thread : threadArray) {
            thread.start();
        }
        for (Thread thread : threadArray) {
            thread.join();
        }
    }

    public static void main(String[] stringArray) throws Exception {
        System.out.println("Starte WarmUp ...");
        mandelbrot.warmUp(stringArray);
        System.out.println("Beende WarmUp ...");
        long l = System.currentTimeMillis();
        for (int i = 0; i < 100; ++i) {
            System.out.print("Benchmark " + i + " :");
            long l2 = System.currentTimeMillis();
            mandelbrot.benchmark(stringArray);
            long l3 = System.currentTimeMillis();
            System.out.println("Gesamtzeit: " + (l3 - l2) + " ms");
        }
        long l4 = System.currentTimeMillis();
        System.out.println("Gesamtzeit: " + (l4 - l) + " ms");
    }
}

