/*
 * Decompiled with CFR 0.152.
 */
final class NBodySystem {
    private Body[] bodies = new Body[]{Body.sun(), Body.jupiter(), Body.saturn(), Body.uranus(), Body.neptune()};

    public NBodySystem() {
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        for (int i = 0; i < this.bodies.length; ++i) {
            d += this.bodies[i].vx * this.bodies[i].mass;
            d2 += this.bodies[i].vy * this.bodies[i].mass;
            d3 += this.bodies[i].vz * this.bodies[i].mass;
        }
        this.bodies[0].offsetMomentum(d, d2, d3);
    }

    public void advance(double d) {
        for (int i = 0; i < this.bodies.length; ++i) {
            Body body = this.bodies[i];
            for (int j = i + 1; j < this.bodies.length; ++j) {
                double d2 = body.x - this.bodies[j].x;
                double d3 = body.y - this.bodies[j].y;
                double d4 = body.z - this.bodies[j].z;
                double d5 = d2 * d2 + d3 * d3 + d4 * d4;
                double d6 = Math.sqrt(d5);
                double d7 = d / (d5 * d6);
                body.vx -= d2 * this.bodies[j].mass * d7;
                body.vy -= d3 * this.bodies[j].mass * d7;
                body.vz -= d4 * this.bodies[j].mass * d7;
                this.bodies[j].vx += d2 * body.mass * d7;
                this.bodies[j].vy += d3 * body.mass * d7;
                this.bodies[j].vz += d4 * body.mass * d7;
            }
        }
        for (Body body : this.bodies) {
            body.x += d * body.vx;
            body.y += d * body.vy;
            body.z += d * body.vz;
        }
    }

    public double energy() {
        double d = 0.0;
        for (int i = 0; i < this.bodies.length; ++i) {
            Body body = this.bodies[i];
            d += 0.5 * body.mass * (body.vx * body.vx + body.vy * body.vy + body.vz * body.vz);
            for (int j = i + 1; j < this.bodies.length; ++j) {
                Body body2 = this.bodies[j];
                double d2 = body.x - body2.x;
                double d3 = body.y - body2.y;
                double d4 = body.z - body2.z;
                double d5 = Math.sqrt(d2 * d2 + d3 * d3 + d4 * d4);
                d -= body.mass * body2.mass / d5;
            }
        }
        return d;
    }
}

