/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;

class fasta {
    static final int IM = 139968;
    static final int IA = 3877;
    static final int IC = 29573;
    static final int LINE_LENGTH = 60;
    static final int BUFFER_SIZE = 62464;
    public static String ALU = "GGCCGGGCGCGGTGGCTCACGCCTGTAATCCCAGCACTTTGGGAGGCCGAGGCGGGCGGATCACCTGAGGTCAGGAGTTCGAGACCAGCCTGGCCAACATGGTGAAACCCCGTCTCTACTAAAAATACAAAAATTAGCCGGGCGTGGTGGCGCGCGCCTGTAATCCCAGCTACTCGGGAGGCTGAGGCAGGAGAATCGCTTGAACCCGGGAGGCGGAGGTTGCAGTGAGCCGAGATCGCGCCACTGCACTCCAGCCTGGGCGACAGAGCGAGACTCCGTCTCAAAAA";
    private static final FloatProbFreq IUB = new FloatProbFreq(new byte[]{97, 99, 103, 116, 66, 68, 72, 75, 77, 78, 82, 83, 86, 87, 89}, new double[]{0.27, 0.12, 0.12, 0.27, 0.02, 0.02, 0.02, 0.02, 0.02, 0.02, 0.02, 0.02, 0.02, 0.02, 0.02});
    private static final FloatProbFreq HOMO_SAPIENS = new FloatProbFreq(new byte[]{97, 99, 103, 116}, new double[]{0.302954942668, 0.1979883004921, 0.1975473066391, 0.3015094502008});

    fasta() {
    }

    static final void makeRandomFasta(String string, String string2, FloatProbFreq floatProbFreq, int n, OutputStream outputStream) throws IOException {
        byte[] byArray = new byte[62464];
        if (byArray.length % 61 != 0) {
            throw new IllegalStateException("buffer size must be a multiple of line length (including line break)");
        }
        String string3 = ">" + string + " " + string2 + '\n';
        outputStream.write(string3.getBytes());
        int n2 = 0;
        while (n > 0) {
            int n3 = n >= 60 ? 60 : n;
            if (n2 == 62464) {
                outputStream.write(byArray, 0, n2);
                n2 = 0;
            }
            n2 = floatProbFreq.selectRandomIntoBuffer(byArray, n2, n3);
            byArray[n2++] = 10;
            n -= n3;
        }
        outputStream.write(byArray, 0, n2);
    }

    static final void makeRepeatFasta(String string, String string2, String string3, int n, OutputStream outputStream) throws IOException {
        byte[] byArray = string3.getBytes();
        int n2 = 0;
        byte[] byArray2 = new byte[62464];
        if (byArray2.length % 61 != 0) {
            throw new IllegalStateException("buffer size must be a multiple of line length (including line break)");
        }
        String string4 = ">" + string + " " + string2 + '\n';
        outputStream.write(string4.getBytes());
        int n3 = 0;
        while (n > 0) {
            int n4 = n >= 60 ? 60 : n;
            if (n3 == 62464) {
                outputStream.write(byArray2, 0, n3);
                n3 = 0;
            }
            for (int i = 0; i < n4; ++i) {
                if (n2 == byArray.length) {
                    n2 = 0;
                }
                byArray2[n3++] = byArray[n2++];
            }
            byArray2[n3++] = 10;
            n -= n4;
        }
        outputStream.write(byArray2, 0, n3);
    }

    public static void main(String[] stringArray) throws IOException {
        long l = System.currentTimeMillis();
        int n = 25000000;
        if (stringArray.length > 0) {
            n = Integer.parseInt(stringArray[0]);
        }
        PrintStream printStream = System.out;
        fasta.makeRepeatFasta("ONE", "Homo sapiens alu", ALU, n * 2, printStream);
        fasta.makeRandomFasta("TWO", "IUB ambiguity codes", IUB, n * 3, printStream);
        fasta.makeRandomFasta("THREE", "Homo sapiens frequency", HOMO_SAPIENS, n * 5, printStream);
        long l2 = System.currentTimeMillis();
        System.out.println("Gesamtzeit: " + (l2 - l) + " ms");
        ((OutputStream)printStream).close();
    }

    public static final class FloatProbFreq {
        static int last = 42;
        final byte[] chars;
        final float[] probs;

        public FloatProbFreq(byte[] byArray, double[] dArray) {
            this.chars = byArray;
            this.probs = new float[dArray.length];
            for (int i = 0; i < dArray.length; ++i) {
                this.probs[i] = (float)dArray[i];
            }
            this.makeCumulative();
        }

        private final void makeCumulative() {
            double d = 0.0;
            for (int i = 0; i < this.probs.length; ++i) {
                this.probs[i] = (float)(d += (double)this.probs[i]);
            }
        }

        public final int selectRandomIntoBuffer(byte[] byArray, int n, int n2) {
            byte[] byArray2 = this.chars;
            float[] fArray = this.probs;
            int n3 = fArray.length;
            block0: for (int i = 0; i < n2; ++i) {
                float f = FloatProbFreq.random(1.0f);
                for (int j = 0; j < n3; ++j) {
                    if (!(f < fArray[j])) continue;
                    byArray[n++] = byArray2[j];
                    continue block0;
                }
                byArray[n++] = byArray2[n3 - 1];
            }
            return n;
        }

        public static final float random(float f) {
            last = (last * 3877 + 29573) % 139968;
            return f * (float)last * 7.14449E-6f;
        }
    }
}

