#!/usr/bin/ruby
# Coding: UTF-8
require 'rubygems'
require 'json'
require 'net/http'
require 'twitter'
require 'pp'

# Konfiguriere die OAuth-Authentifikation
Twitter.configure do |config|
  config.consumer_key = "3XrliUSfNYsYBgturS5Fg" 
  config.consumer_secret = "J5wUXCy7FNxqEkcLXJJTqZy8HDgtCdWHxRroEyf7YRI"
  config.oauth_token = "9731502-QgdiK5PHSaemMcLxFqIBhrzWGVI69zHPVlns0IKok"
  config.oauth_token_secret = "xUYUhmFYgSTA37G6OsUpQy0HY1qm6c4cbwtkGRF5nc"
end

def contains(text, text_array)
	text_array.each do |word|
		if(!text.index(word).nil?) 
			return true
		end
	end
	return false
end

def clean_tweet(tweet)
	name_cleaned = []
	stripped = tweet.chomp
	stripped = stripped.gsub(/\./, '')
	split = stripped.split
	split.each do |word|
		if(!word.start_with?("@"))
			name_cleaned << word
		end
	end
	cleaned = name_cleaned.join(' ')
	cleaned = cleaned.downcase
	return cleaned
end

# Gibt <=-1 für negativ, >=1 für positiv und 0 für neutral zurück
def positiv_negativ_or_neutral(tweet) 
  emotion_result = 0
  # positive Emoticons
  positiv_emoticons = [":)",";)",":-)",":-)",":D",":-D",";]",":]",":p",":-p",";p",";-p"]
  # 24 positive Adjektive nach Finn Årup Nielsen gewichtet
  positiv_words = {
  	"überglücklich" => 3, "mutig" => 2, "schlau" => 2,
  	"zuversichtlich" => 2,"neugierig" => 1, "begeistert" => 1,
  	"gerecht" => 2, "freundlich" => 1, "froh" => 3, 
  	"gut" => 3, "toll" => 4, "glücklich" => 3, 
  	"interessiert" => 2, "freudig" => 3, "verliebt" => 3, 
  	"liebe" => 3, "nett" => 3, "optimistisch" => 2, 
  	"erfreut" => 2, "zufrieden" => 2, "friedlich" => 2,
  	"vernünftig" => 2, "wunderbar" => 4,"super" => 5
  }
  # negative Emoticons
  negativ_emoticons = [":-(",":(",")-:"]
  # negative Hashtags
  negativ_hashtags = ["#wtf","#wth","#shit","#fuck","#such","#hate","#hass"]
  # 24 negative Adjektive nach Finn Årup Nielsen gewichtet  
  negativ_words = {
	"wütend" => -3,"schrecklich" => -3, "schlecht" => -3,
    "konfus" => -1, "verrückt" => -2, "enttäuscht" => -2,
    "angeekelt" => -3, "erzürnt" => -3, "erschöpft" => -2,
    "verängstigt" => -2, "schuldig" => -3, "hilflos" => -2,
    "entsetzt" => -3, "verletzte" => -2, "hysterisch" => -3,
    "gleichgültig" => -3,"eifersüchtig" => -2, "einsam" => -2, 
    "wahnsinning" => -2, "boshaft" => -5, "elend" => -3,
    "gemein" => -2,"traurig" => -2, "dumm" => -1, "furchtbar" => -3
  }

  # 1. Analyseschritt: Beim Auffinden starker Metadaten entscheide gleich...
  if(contains(tweet, positiv_emoticons)) 
    return 1
  end
  
  if(contains(tweet,negativ_emoticons)) 
    return -1
  end
  
  if(contains(tweet, negativ_hashtags)) 
    return -1
  end

  # 2. Analyseschritt: Textanalyse
  tweet_words = tweet.split

  word_count = tweet_words.length
  positive_count = 0.0
  negativ_count = 0.0
  
  sum = 0
  tweet_words.each do |word|
  	sum += positiv_words.fetch(word, 0)
  	sum += negativ_words.fetch(word, 0)
  end
  
  return sum / Math.sqrt(word_count);
end

# Suchbegriff (Produkt, Marke etc.)
soft_drinks = ["almdudler","bionade","cola","kola","sprite",
			   "fanta","lift","icetea","mezzomix","nestea","fritzkola",
			   "clubmate","redbull","rivella","spezi","sunkist",
			   "schweppes","gingerale","sodawater","bitterlemmon",
			   "orangina","mirinda","sunkist","caprisonne",
			   "isosport","pepsi","drpepper","africola",
			   "lemonaid","charitea","sinalco","vitaminwater",
			   "lipton","apfelsaftschorle","redbullcola","cocacola"]

# Anzahl Suchergebnisse
number_results = 100

# Datei mit positiven Trainingsdaten
positives = File.new("positiv-tweets.txt", "w")

# Datei mit negativen Trainigsdaten
negatives = File.new("negativ-tweets.txt", "w")

# Anzahl neutraler, negative oder positiver Tweets
pos = 0;
neg = 0;
neu = 0;

soft_drinks.each do |query| 
	begin
    Twitter.search("#{query}", :lang => "de", :count => number_results).results.map do |status|
    	puts "#{status.text}"
    	tweet_text = clean_tweet(status.text)
    	sentiment = positiv_negativ_or_neutral(tweet_text); 
    	if(sentiment == 0) 
    		puts "NEUTRAL:#{sentiment}\t#{tweet_text}\n";
    		neu+=1
    	elsif(sentiment >= 1)
    		puts "POSITIV:#{sentiment}\t#{tweet_text}";
        	positives.puts "positiv\t#{tweet_text}";
        	pos+=1
        	puts "------------------------------------------";
    	elsif(sentiment <= -1)
    		puts "NEGATIV:#{sentiment}\t#{tweet_text}";
        	negatives.puts "negativ\t#{tweet_text}";
        	neg+=1
        	puts "------------------------------------------";
    	end 
	end
	
	rescue Twitter::Unauthorized
  	puts "Nicht autorisiert. Bitte prüfen Sie die Twitter Credentials."
   
  rescue Twitter::BadRequest => e
  	puts "Abfragelimit erreicht. Es kann weitergehen in #{e.ratelimit_reset}"
  	sleep e.retry_after
  	retry

  rescue Exception => e
    puts "Es ist folgender Fehler aufgetreten:"
    puts e.message
  end	
end

puts "Anzahl positiver Tweets: #{pos}"
puts "Anzahl negativer Tweets: #{neg}"
puts "Anzahl neutraler Tweets: #{neu}"
positives.close
negatives.close


