// Copyright (c) 2013 Oliver Lau <ola@ct.de>, Heise Zeitschriften Verlag

#include <stdio.h>
#include <time.h>
#include <string.h>
#include <stdlib.h>

#define N 624
#define M 397
#define LO 0x7fffffffU
#define HI 0x80000000U

static unsigned int mt_y[N];
static int mt_index;
static const unsigned int mt_A[2] = { 0x0U, 0x9908b0dfU };

void mt_seed(unsigned int);
unsigned int mt_rand(void);


void mt_warmup(void)
{
  int i;
  for (i = 0; i < 10000; ++i)
    mt_rand();
}


void mt_seed(unsigned int seed)
{
  unsigned int r = seed;
  unsigned int s = 3402;
  int i;
  for (i = 0; i < N; ++i) {
    r = 509845221U * r + 3U;
    s *= s + 1;
    mt_y[i] = s + (r >> 10);
  }
  mt_index = 0;
  mt_warmup();
}


unsigned int mt_rand(void)
{
  int k;
  unsigned int h;
  unsigned int e;
  if (mt_index == N) {
    for (k = 0 ; k < N-M ; ++k) {
      h = (mt_y[k] & HI) | (mt_y[k+1] & LO);
      mt_y[k] = mt_y[k+M] ^ (h >> 1) ^ mt_A[h & 1];
    }
    for (k = N-M ; k < N-1 ; ++k) {
      h = (mt_y[k] & HI) | (mt_y[k+1] & LO);
      mt_y[k] = mt_y[k+(M-N)] ^ (h >> 1) ^ mt_A[h & 1];
    }
    h = (mt_y[N-1] & HI) | (mt_y[0] & LO);
    mt_y[N-1] = mt_y[M-1] ^ (h >> 1) ^ mt_A[h & 1];
    mt_index = 0;
  }
  e = mt_y[mt_index++];
  e ^= (e >> 11);
  e ^= (e << 7) & 0x9d2c5680U;
  e ^= (e << 15) & 0xefc60000U;
  e ^= (e >> 18);
  return e;
}


#define RNG_COUNT 100000

int main() {
  unsigned int* r;
  int i;
  struct timespec t0, t1;
  r = (unsigned int*)malloc(RNG_COUNT * sizeof(*r));
  mt_seed(clock());
  clock_gettime(0, &t0);
  for (i = 0; i < RNG_COUNT; ++i)
    r[i] = mt_rand();
  clock_gettime(0, &t1);
  printf("time: %f ms\n", 1e-6 * (t1.tv_nsec - t0.tv_nsec));
  free(r);
  return 0;
}
