using System;
using System.Text;
using System.Runtime.InteropServices;

namespace Gesundheitskarte
{
	internal sealed class WinSCard
	{

		// Import der benutzten PC/SC-Funktionen
		[DllImport("WINSCARD.DLL", CharSet=CharSet.Auto)]
		internal static extern uint SCardConnect(IntPtr hContext, string szReader, uint dwShareMode, uint dwPreferredProtocols, out IntPtr phCard, out uint pdwActiveProtocol);

		[DllImport("WINSCARD.DLL")]
		internal static extern uint SCardDisconnect(IntPtr hCard, uint dwDisposition);

		[DllImport("WINSCARD.DLL")]
		internal static extern uint SCardEstablishContext(uint dwScope, IntPtr pvReserved1, IntPtr pvReserved2, out IntPtr phContext);

		[DllImport("WINSCARD.DLL")]
        internal static extern uint SCardGetAttrib(IntPtr hCard, uint dwAttrId, byte[] pbAttr, ref int pcbAttrLen);

		[DllImport("WINSCARD.DLL", CharSet=CharSet.Auto)]
		internal static extern uint SCardListReaders(IntPtr hContext, string mszGroups, ref IntPtr pmszReaders, ref uint pcchReaders);

		[DllImport("WINSCARD.DLL")]		
        internal static extern uint SCardTransmit(IntPtr hCard, ref SCARD_IO_REQUEST pioSendPci, [In] byte[] pbSendBuffer, int cbSendLength, IntPtr pioRecvPci, [In, Out] byte[] pbRecvBuffer, ref int pcbRecvLength);

        
        public struct SCARD_IO_REQUEST
        {
            public UInt32 dwProtocol;
            public UInt32 cbPciLength;
        }

	}
}
