using System;
using System.Runtime.InteropServices;

namespace Gesundheitskarte
{

    // Short-FileIDs der EFs im root
    public enum MF
    {
        PuK_CH_AUT = 0x01,
        PuK_CH_ENC = 0x02,
        GDO = 0x02, 
        AUTH_CVC = 0x03,
        CA_eGK = 0x04,
        VERSION = 0x10,
        ATR = 0x1D,
        DIR = 0x1E
    }


    // Short-FileIDs der Anwendung ESIGN
    public enum ESIGN
    {
        PuK_CH_AUT = 0x01,
        PuK_CH_ENC = 0x02
    }

    // Short-FileIDs der Anwendung HCA
    public enum HCA
    {
        PD = 0x01,
        VD = 0x02,
        VDStatus = 0x0C
    }

    
    public enum PinStatus
    {
        // keine Verifikation noetig
        NoError = 0x9000,

        // Passwortobjekt ist mit einem Transportschutz versehen
        Transport_PIN_Zufallszahl = 0x62C1,
        Transport_PIN_abgeleitet  = 0x62C2,
        Transport_PIN_Leerpin_2   = 0x62C4,
        Transport_PIN_festerWert  = 0x62C5,
        Transport_PIN_Leerpin_1   = 0x62C7,
        Transport_PIN_0000        = 0x62CF,

        // kein Transportschutz aktiv
        RetryCounter = 0x63C0,

        // kein Passwort
        PasswordNotFound = 0x6A88
    }

    public enum EGKtyp
    {
        G1 = 1,
        G1plus = 2,

        unbekannt = 5000
    }
    
    
    public enum SCardAccessMode
	{		
		Exclusive = 1,
		Shared = 2,
        Direct = 3
	}


	public enum SCardContextScope
	{
        User = 0,
        Terminal = 1,
        System = 2,
	}
 

    [Flags]
    public enum SCardProtocolIdentifiers
	{
		Default = -2147483648,
		Optimal = 0,
		Raw = 0x10000,
		T0 = 1,
		T1 = 2,
		Undefined = 0
	}

 
	public enum SCardDisposition
	{
        LeaveCard = 0,
		ResetCard = 1,
		UnpowerCard = 2,
        EjectCard = 3,
        Confiscate = 4		
	}

}