﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using Windows.Foundation;
using Windows.Foundation.Collections;
using Windows.UI.Xaml;
using Windows.UI.Xaml.Controls;
using Windows.UI.Xaml.Controls.Primitives;
using Windows.UI.Xaml.Data;
using Windows.UI.Xaml.Input;
using Windows.UI.Xaml.Media;
using Windows.UI.Xaml.Navigation;

// Die Elementvorlage "Benutzersteuerelement" ist unter http://go.microsoft.com/fwlink/?LinkId=234236 dokumentiert.

namespace Actien.UI
{
    public sealed partial class HistoryChart : UserControl
    {
        public HistoryChart()
        {
            this.InitializeComponent();
        }

        public List<Tuple<DateTime, decimal>> Values
        {
            get { return (List<Tuple<DateTime, decimal>>)GetValue(ValuesProperty); }
            set { SetValue(ValuesProperty, value); }
        }

        // Using a DependencyProperty as the backing store for Values.  This enables animation, styling, binding, etc...
        public static readonly DependencyProperty ValuesProperty =
            DependencyProperty.Register("Values", typeof(List<Tuple<DateTime, decimal>>), typeof(HistoryChart), new PropertyMetadata(new List<Tuple<DateTime, decimal>>(), new PropertyChangedCallback(OnValuesChanged)));

        private static void OnValuesChanged(DependencyObject d, DependencyPropertyChangedEventArgs e)
        {
            HistoryChart hc = d as HistoryChart;
            if (hc != null)
                hc.RecalcChart();
        }

        // Umrechnen der in Values gespeicherten Daten und Kurse in Koordinaten zum Zeichnen.
        // Das Zielrechteck berechnet sich nicht aus der Größe des Controls selbst, sondern aus den
        // (in der XAML.Datei festgelegten) Koordinaten der Achsen. Die müssen dazu in die richtige
        // Richtung zeigen und können in einer abgeleiteten Klasse, z. B. für eine Detail-Seite, einen
        // größeren Rand mit Beschriftungen definieren.
        private void RecalcChart()
        {
            if (Values == null || Values.Count == 0)
            {
                this.curve.Points = new PointCollection();
                return;
            }
            double minVal = (double)Values.Min(v => v.Item2);
            double maxVal = (double)Values.Max(v => v.Item2);
            if (maxVal == minVal)
                maxVal = minVal + 10;
            DateTime dtStart = Values.First().Item1;
            DateTime dtEnd = Values.Last().Item1;
            if (dtEnd == dtStart)
                dtStart = dtEnd - TimeSpan.FromDays(1);
            double width = xAxis.X2 - xAxis.X1;
            double height = yAxis.Y2 - yAxis.Y1;
            double pixelsPerTick = width / (dtEnd.Ticks - dtStart.Ticks);
            double pixelsPerDollar = height / (maxVal - minVal);
            PointCollection points = new PointCollection();
            foreach (var record in Values)
            {
                double x = xAxis.X1 + (record.Item1.Ticks - dtStart.Ticks) * pixelsPerTick;
                double y = yAxis.Y1 + (((double)record.Item2) - minVal) * pixelsPerDollar;
                points.Add(new Point(x, y));
            }
            curve.Points = points;
        }
    }
}

