/*
	COPYRIGHT 2011 Christian Nolte
    
    This file is part of my_engrave.

    my_engrave is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    my_engrave is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with my_engrave.  If not, see <http://www.gnu.org/licenses/>.

    Diese Datei ist Teil von my_engrave.

    my_engrave ist Freie Software: Sie knnen es unter den Bedingungen
    der GNU General Public License, wie von der Free Software Foundation,
    Version 3 der Lizenz oder (nach Ihrer Option) jeder spteren
    verffentlichten Version, weiterverbreiten und/oder modifizieren.

    my_engrave wird in der Hoffnung, dass es ntzlich sein wird, aber
    OHNE JEDE GEWHELEISTUNG, bereitgestellt; sogar ohne die implizite
    Gewhrleistung der MARKTFHIGKEIT oder EIGNUNG FR EINEN BESTIMMTEN ZWECK.
    Siehe die GNU General Public License fr weitere Details.

    Sie sollten eine Kopie der GNU General Public License zusammen mit diesem
    Programm erhalten haben. Wenn nicht, siehe <http://www.gnu.org/licenses/>.

*/

#include"xyplotter.h"
#include <unistd.h>  
#include <stdio.h>
#include <stdlib.h>

#define MAXSTEPS 500
#define MAXWAYMM 38

extern int yyparse(void);

CXYPlotter my_plotter;

main()
{
	system("setser.bat");
	yyparse();

}

int mygoto(float x,float y)
{
	my_plotter.GotoA((int)(x*MAXSTEPS/MAXWAYMM),(int) (y*MAXSTEPS/MAXWAYMM));
}

void mymotoroff()
{
	my_plotter.MotorStop();
}

void mySetStepDelay(double speed)
{
	unsigned int calcdelayi;
	double calcdelay;
	
	calcdelay=(MAXWAYMM*60)/(speed*MAXSTEPS);
	printf("calcdelay ist %f\n",calcdelay);


	calcdelay*=1000000;
	printf("calcdelay ist %f\n",calcdelay);


	calcdelayi=(unsigned int)calcdelay;
	printf("calcdelayi ist %d\n",calcdelayi);
	my_plotter.SetStepDelay(calcdelayi);
	
}

void mylaseroff()
{
    my_plotter.LaserOFF();
}

void mylaseron()
{
    my_plotter.LaserON();
	my_plotter.MotorStop();

	printf("5 Sekunden Zeit zum einbrennen!!!!!!\n");
	sleep(5);  //pause zum einbrennen
}
