#!/usr/bin/perl -w

# ct_checkeventswmi.pl (c) c't/Peter Siering, GPLv3
# Liest per WMI Windows-Ereignisprotokolle;
# dazu muss ein wmic-Binary im Pfad erreichbar sein; 
# die Credentials fuer den Zugriff auf Windows liegen
# je host in /etc/wmic; via Zeitstempel (in /tmp)
# liest das Skript jeweils nur die Ereignisse seit
# dem letzten Lauf; eine blacklist-Datei kann
# ausgewaehlte Ereignisse unterdruecken.
#
# Weitere Hinweise in c't 12/2012, S. 184

use strict;

# Parameter
my ( $host, $credentials, $fqhn, $timeframe, $stampfile,
     $blacklistfile, $pos, $lastpos, @fields, $field, @lines,
     $count, $out, @blacklist, $now, $start, $stop, $line,
     $data, $lastchar, $break, $blacklisted);
$host=$ARGV[0];
$credentials="/etc/wmic/wmic_$host.cred";
$fqhn="$host";
#.ct.heise.de";
$timeframe="20 days ago";
$stampfile="/tmp/$host.check_wmi_events.ts";
$blacklistfile="/etc/wmic/blacklist_wmi_events.lst";
# Arbeitsvariablen
$pos=0; $lastpos=15;
@fields=(); @lines=();
$field=""; $count=0;
@blacklist=(); $out="";
# Zeitmarken vorbereiten
$now=`date "+%Y%m%d%H%M%S.000000+***"`;
chop( $now);
if ( -r "$stampfile") { $start=`cat $stampfile`; }
else { $start=`date --date="$timeframe" "+%Y%m%d%H%M%S.000000+***"`; }
$stop="$now";
chop( $start); chop( $stop);
system( "echo \"$now\" > $stampfile");
# WMI befragen
system( "wmic -A $credentials //$fqhn \"select * from Win32_NTLogEvent \
where Logfile='System' and eventtype=1 and timewritten >= '$start' and \
timewritten <= '$stop'\" | tail -n +3 | head -10 > /tmp/check_wmi.tmp");
system( "wmic -A $credentials //$fqhn \" select * from Win32_NTLogEvent \
where Logfile='Application' and eventtype=1 and timewritten >= '$start' \
and timewritten <= '$stop'\" | tail -n +3 | head -10 >> /tmp/check_wmi.tmp");
# WMI Daten nachbearbeiten
open( TMPFILE, "</tmp/check_wmi.tmp");
while ( read( TMPFILE, $data, 1) != 0) {
    if ( $data eq "|") { $pos++; push( @fields, $field); $field=""; next; }
    if (( $data eq "\n") && ( $pos eq $lastpos)) {
	push( @fields, $field);
	$line=$fields [11].": ".substr( $fields [9], 0, 70)."(".$fields [4].")\n";
	push( @lines, $line); $pos=0; @fields=(); $field=""; next; 
    }
    if ( $data eq "\n") {
	if ( $lastchar ne " ") { $field=$field." "; }
    } else { $field=$field.$data; $lastchar=$data; }
}
close( TMPFILE);
# Nagios-Status aufbereiten, gegencheck Blacklist
open( BL, "<$blacklistfile");
while ( <BL>) { push( @blacklist, $_); }
close( BL);
foreach $line ( @lines) { 
    undef( $break);
    foreach $blacklisted ( @blacklist) {
	if ( $line =~ m/$blacklisted/) { $break="yeah"; last; }
    }
    if ( defined ($break)) { next; }
    $out= $out.$line; $count++;
}
if ( $count gt 0) { print "CRITICAL - $count error events - $out\n"; exit 2; }
else { print "OK - no error events\n"; exit 0; }

