/*
 *  GestureLibrary.h
 *  Gesture Library
 *
 *  Created by Andy Abgottspon on 07.01.10.
 *  Copyright 2010 aaweb. All rights reserved.
 *
 */

#ifndef GESTURE_LIBRARY_H
#define GESTURE_LIBRARY_H

#import "ofMain.h"

#import "ofxOpenCv.h"
#import "ofxVectorMath.h"
#import "ofxiPhoneVideoGrabber.h"

#import "Hand.h"

// CONFIG
#define GESTLIB_GRAB_TOLERANCE          0.3
#define GESTLIB_HISTORY_STEPS           10  // how many frames will be tracked back to recognise a gesture
#define GESTLIB_DOUBLE_STEPS            7   // Tolerance for double gesture recognition in frames (steps) 
#define GESTLIB_MIN_SWIPE_SIZE          120 // how many pixels a swipe has to be
#define GESTLIB_MAX_GRAB_RELEASE_RADIUS 50  // allowed radius for grab and release (so moving hands are not considered grabs)
#define GESTLIB_CONTOUR_MIN_SIZE        800 
#define GESTLIB_MIN_NEW_HAND_SIZE       60 

// GESTURES
#define GEST_NONE               0
#define GEST_SWIPE_LEFT         1
#define GEST_SWIPE_RIGHT        2
#define GEST_GRAB               3
#define GEST_RELEASE            4

#define GEST_DOUBLE_GRAB        5
#define GEST_DOUBLE_RELEASE     6

// GESTURE MODES
#define GEST_TYPE_DEFAULT       0
#define GEST_TYPE_INPROGRESS    1

class GestureLibrary {

public:
    void                    setup(int camWidth = 640, int camHeight = 480, int thres = 70);
    void                    update();
    bool                    processGestures(); 
    CGImageRef              getCurrentFrame(){ return vidGrabber.getCurrentFrame(); }
    ofColor                 getColor(int x, int y);
    
    int                     getDoubleGesture() { return doubleGesture; };
    int                     getDoubleGestureType() { return doubleGestureType; };
    int                     getDoubleGestureHand1() { return doubleGestureHand1; };
    int                     getDoubleGestureHand2() { return doubleGestureHand2; };
    ofPoint                 getImageSize() { return imgSize; };
    vector<Hand>            getHands() { return hands; };
    
    ofColor                 getHandColor() { return handColor; };
    void                    setHandColor(ofColor col) { handColor = col; };
    void                    setHandColor(int r, int g, int b) { 
                                ofColor tmpCol;
                                tmpCol.r = r;
                                tmpCol.g = g;
                                tmpCol.b = b;
                                handColor = tmpCol; 
                            };
    
    int                     getColorThreshold() { return threshold; };
    void                    setColorThreshold(int thres) { threshold = thres; };
    
    char                    debugStr[1024];
    ofxCvColorImage		    colorImg;
    ofxCvGrayscaleImage 	grayImage;
    ofxCvGrayscaleImage 	grayBg;
    ofxCvGrayscaleImage 	grayDiff;
    ofxCvGrayscaleImage 	grayMask;
    
private:
    vector<ofPoint>         groupPoints(vector<ofPoint> &defectVec, float dist, int recursiveCount);
    float                   calcDistance(ofPoint &pA, ofPoint &pB);
    void                    processBlob(int blobInd);
    
    ofxiPhoneVideoGrabber   vidGrabber;
    ofxCvContourFinder 	    contourFinder;
	
    vector<Hand>		    hands;
    ofPoint				    imgSize;
    ofColor                 handColor;
    ofPoint				    handPos;
    vector<ofPoint>		    vHandPos;
    vector<ofRectangle>     vHandRect;    
    
    int 				    threshold;
    int 				    contourMinSize;
    bool				    blGroupTips;
    bool				    blPaused;
    bool				    blDebug;
    bool				    blAdaptColor;
    int                     doubleGesture;
    int                     doubleGestureType;
    int                     doubleGestureHand1;
    int                     doubleGestureHand2;
};

#endif
