﻿Imports Microsoft.Win32.Registry

Module modMain
    Public AppName As String = My.Application.Info.Title
    Public AppVersion As String = My.Application.Info.Version.ToString
    Public AppInfo As String = "www.briefblitz.com"
    Public IconsInfo As String = "www.visualpharm.com"

    Public RegSubKeyName_PDFCreator As String = "Software\PDFCreator\Program"
    Public RegValueName_Language As String = "Language"
    Public RegValueName_RunProg As String = "RunProgramAfterSaving"
    Public RegValueName_PName As String = "RunProgramAfterSavingProgramname"
    Public RegValueName_PParms As String = "RunProgramAfterSavingProgramParameters"

    '******************************************************************************************
    'Routinen
    '******************************************************************************************

    Public Function String2StringCollection(ByVal SammelString As String, ByVal Delimiter As String) As System.Collections.Specialized.StringCollection
        Dim tempCollection As New System.Collections.Specialized.StringCollection

        For Each EinzelString As String In SammelString.Split(Delimiter)
            If EinzelString > "" Then
                tempCollection.Add(EinzelString)
            End If
        Next

        Return tempCollection
    End Function

    Public Function StringCollection2String(ByVal StringCollection As System.Collections.Specialized.StringCollection, ByVal Delimiter As String) As String
        Dim temp As String = ""

        For Each EinzelString As String In StringCollection
            If EinzelString > "" Then
                temp = temp & Delimiter & EinzelString
            End If
        Next
        If temp.StartsWith(Delimiter) Then
            temp = temp.Substring(1)
        End If

        Return temp
    End Function

    Public Sub SaveToMruList(ByVal MruList As System.Collections.Specialized.StringCollection, _
                             ByVal MruEntry As String, ByVal MruMaxEntries As Integer)
        With MruList
            'Wenn Eintrag schon in MRU-Liste enthalten ist, dann...
            If .Contains(MruEntry) Then
                '... Eintrag daraus entfernen
                '(sorgt dafür, dass zuletzt geöffneter Eintrag immer am Listenanfang steht)
                .RemoveAt(.IndexOf(MruEntry))
            End If

            'Übergebenen Eintrag am Anfang der Liste einfügen
            .Insert(0, MruEntry)

            'Wenn MRU-Liste mehr Einträge als erlaubt enthält, dann...
            If .Count > MruMaxEntries Then
                '... letzten Eintrag entfernen
                .RemoveAt(.Count - 1)
            End If
        End With
    End Sub

    Public Sub MruUpdateComboBox(ByVal MruComboBox As ComponentFactory.Krypton.Toolkit.KryptonComboBox, _
                                 ByVal MruList As System.Collections.Specialized.StringCollection)
        'ComboBox-Liste neu mit MruList-Einträgen füllen
        With MruComboBox
            .Items.Clear()

            For Each MruEntry As String In MruList
                .Items.Add(MruEntry)
            Next
        End With
    End Sub

    Public Function HKCU_ValueLesen(ByVal SubKeyName As String, ByVal ValueName As String, DefaultValue As Object) As Object
        Dim ValueWert As Object = Nothing

        'Subkey öffnen
        Dim regKey As Microsoft.Win32.RegistryKey = CurrentUser.OpenSubKey(SubKeyName)
        'Wenn Subkey existiert, dann...
        If regKey IsNot Nothing Then
            Try
                '... angegebenen Value lesen
                ValueWert = regKey.GetValue(ValueName)

                'Wenn Value nicht existiert, dann...
                If ValueWert Is Nothing Then
                    '... DefaultValue übernehmen
                    ValueWert = DefaultValue
                End If

                'Wenn das nicht gelingt, dann...
            Catch ex As Exception
                '... Fehler anzeigen
                Debug.WriteLine(ex.Message)
            End Try

            'Wenn Subkey NICHT existiert, dann...
        Else
            '... DefaultValue übernehmen
            ValueWert = DefaultValue
        End If

        'Value zurückgeben
        Return ValueWert
    End Function

    Public Function HKCU_ValueSchreiben(ByVal SubKeyName As String, ByVal ValueName As String, _
    ByVal ValueWert As Object, Optional ByVal ValueTyp As Microsoft.Win32.RegistryValueKind = _
    Microsoft.Win32.RegistryValueKind.String) As Boolean

        Dim Erfolg As Boolean = False

        'Subkey öffnen
        Dim regKey As Microsoft.Win32.RegistryKey = CurrentUser.OpenSubKey(SubKeyName, True)
        'Wenn Subkey NICHT existiert, dann...
        If regKey Is Nothing Then
            Try
                '... zunächst anlegen
                regKey = CurrentUser.CreateSubKey(SubKeyName)

                'Wenn das nicht gelingt, dann...
            Catch ex As Exception
                '... Fehler anzeigen
                Debug.WriteLine(ex.Message)
                'False zurückgeben
                Return False
            End Try
        End If

        Try
            'Value schreiben
            regKey.SetValue(ValueName, ValueWert, ValueTyp)

            'Erfolg signalisieren
            Erfolg = True

            'Wenn das nicht gelingt, dann...
        Catch ex As Exception
            '... Fehler anzeigen
            Debug.WriteLine(ex.Message)
        End Try

        'Ergebnis zurückgeben
        Return Erfolg
    End Function
End Module

